/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.reply;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.model.UxExtraNavigationTree;
import crazydev.iccube.ux.common.app.UxApp;
import crazydev.iccube.ux.common.json.UxJsonUtils;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.reply.UxRestPayloadReply;
import crazydev.iccube.ux.common.reply.payload.UxReplyPayload;
import crazydev.iccube.ux.common.reply.payload.UxReplyPayloadWarning;
import crazydev.iccube.ux.common.reply.payload.UxReplyStatus;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxPayloadReply
extends UxReply
implements UxSerializable {
    public static final String VERSION_ONE = "1";
    private final String version;
    private final String status;
    private final UxReplyPayload payload;

    public UxPayloadReply(UxReplyStatus status, UxReplyPayload payload) {
        this(VERSION_ONE, status.lowerCaseString(), payload);
    }

    private UxPayloadReply(String version, String status, UxReplyPayload payload) {
        this.version = version;
        this.status = status;
        this.payload = payload;
    }

    @Override
    public boolean isMdxOnError() {
        return this.payload.isMdxOnError();
    }

    @Override
    @Nullable
    public OlapSchemaLifeCycleStatus extractSchemaLifeCycleStatus() {
        return this.payload != null ? this.payload.extractSchemaLifeCycleStatus() : null;
    }

    public boolean hasUseCase() {
        return this.payload.hasUseCase();
    }

    @Nullable
    public UxUseCase currentUseCase() {
        return this.payload.currentUseCase();
    }

    public boolean isCurrentUseCaseWithSemanticLayerExtraNavigation() {
        return this.payload.isCurrentUseCaseWithSemanticLayerExtraNavigation();
    }

    public boolean isCurrentUseCaseWithMeasuresExtraNavigation() {
        return this.payload.isCurrentUseCaseWithMeasuresExtraNavigation();
    }

    public boolean isForSchemaDefRevisions() {
        return this.payload.isForSchemaDefRevisions();
    }

    public UxPayloadReply withApps(List<UxApp> apps) {
        this.payload.attachApps(apps);
        return this;
    }

    public UxPayloadReply withWarning(@Nullable UxReplyPayloadWarning warning) {
        this.payload.attachWarning(warning);
        return this;
    }

    public UxPayloadReply withUseCases(@Nullable String appTitle, List<UxUseCase> useCases, @Nullable UxExtraNavigationTree extraNavigation) {
        this.payload.attachUseCases(appTitle, useCases, extraNavigation);
        return this;
    }

    public UxPayloadReply withUseCaseAdditionalInfo(String useCaseAdditionalInfo) {
        this.payload.attachUseCaseAdditionalInfo(useCaseAdditionalInfo);
        return this;
    }

    public UxPayloadReply withUseCase(UxUseCase useCase) {
        this.payload.attachUseCase(useCase);
        return this;
    }

    public UxPayloadReply withLicenseExpiryWarning(String info) {
        this.payload.attachLicenseExpiryWarning(info);
        return this;
    }

    public UxPayloadReply withOOM(String info) {
        this.payload.attachOOM(info);
        return this;
    }

    @Override
    public void writeResponse(UxBabylonService babylon, HttpServletRequest request, HttpServletResponse response, UxApi api) throws IOException {
        this.writeHeaders(response, api);
        this.writeReply(babylon, (OutputStream)response.getOutputStream(), api);
    }

    protected void writeHeaders(HttpServletResponse response, UxApi api) {
        if (api == UxApi.REST) {
            response.setContentType("application/json; charset=UTF-8");
        } else {
            response.setContentType("text/plain; charset=UTF-8");
        }
    }

    protected void writeReply(UxBabylonService babylon, OutputStream out, UxApi api) throws IOException {
        UxRestPayloadReply replyP;
        Object reply;
        GsonBuilder builder = UxJsonUtils.gson();
        if (api == UxApi.REST) {
            reply = new UxRestPayloadReply(this.version, this.status, this.payload.toRestFormat());
            builder = builder.addSerializationExclusionStrategy(new ExclusionStrategy(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean shouldSkipField(FieldAttributes f) {
                    String name = f.getName();
                    if (name.equals("cookies")) {
                        Class clazz = f.getDeclaringClass();
                        return UxReply.class.equals((Object)clazz);
                    }
                    return false;
                }

                public boolean shouldSkipClass(Class<?> clazz) {
                    return false;
                }
            });
        } else {
            reply = this;
        }
        if (reply instanceof UxRestPayloadReply && (replyP = (UxRestPayloadReply)reply).isWritable()) {
            replyP.write(out);
            out.flush();
            return;
        }
        if (this.payload.serializeSpecialFloatingPointValues()) {
            builder = builder.serializeSpecialFloatingPointValues();
        }
        Gson gson = builder.create();
        String replyS = gson.toJson(reply);
        byte[] replyB = replyS.getBytes("UTF-8");
        out.write(replyB);
        out.flush();
    }

    @Override
    public void release() {
        try {
            this.payload.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

