/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.reply;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import crazydev.iccube.ux.common.json.UxJsonUtils;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxFileUploadReply
extends UxReply {
    @Nullable
    private final String error;
    @Nullable
    private final Object extra;

    private UxFileUploadReply() {
        this(null);
    }

    private UxFileUploadReply(@Nullable String error) {
        this(error, null);
    }

    private UxFileUploadReply(@Nullable String error, @Nullable Object extra) {
        this.error = error;
        this.extra = extra;
    }

    public static UxFileUploadReply success() {
        return new UxFileUploadReply();
    }

    public static UxFileUploadReply success(@Nullable Object extra) {
        return new UxFileUploadReply(null, extra);
    }

    public static UxFileUploadReply error(String error) {
        return new UxFileUploadReply(error);
    }

    public static UxFileUploadReply error(UxValidationResult errors) {
        StringBuilder error = new StringBuilder();
        List<UxValidationMessage> messages = errors.getMessages();
        for (int ii = 0; ii < messages.size(); ++ii) {
            UxValidationMessage message = messages.get(ii);
            if (ii > 0) {
                error.append("\n");
            }
            error.append(message.getMessage());
        }
        return new UxFileUploadReply(error.toString());
    }

    @Override
    public void writeResponse(UxBabylonService babylon, HttpServletRequest request, HttpServletResponse response, UxApi api) throws IOException {
        GsonBuilder builder = UxJsonUtils.gson();
        Gson gson = builder.create();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.extra != null) {
            result.put("success", true);
            result.put("extra", this.extra);
        } else if (this.error != null) {
            result.put("error", this.error);
        } else {
            result.put("success", true);
        }
        String content = gson.toJson(result);
        byte[] contentB = content.getBytes(StandardCharsets.UTF_8);
        ServletOutputStream out = response.getOutputStream();
        out.write(contentB);
        out.flush();
    }
}

