/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.query;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryParser;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.query.UxQueryParserRepository;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.unknown.UxUnknownQuery;
import crazydev.iccube.ux.console.queries.unknown.UxUnknownQueryMeta;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class UxQueryParserHelper {
    private UxQueryParserHelper() {
    }

    public static UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String pathInfo = params.getPathInfo();
        UxQuery query = pathInfo.startsWith("/console/admin") ? UxQueryParserHelper.parseQuery(params, pathInfo.substring("/console/admin".length()), UxConsoleConstants.QueryName.AdminHome) : (pathInfo.startsWith("/console/builder") ? UxQueryParserHelper.parseQuery(params, pathInfo.substring("/console/builder".length()), UxConsoleConstants.QueryName.BuilderHome) : (pathInfo.startsWith("/console/mdx") ? UxQueryParserHelper.parseQuery(params, pathInfo.substring("/console/mdx".length()), UxConsoleConstants.QueryName.MdxConsoleHome) : (pathInfo.startsWith("/console/riskpro") ? UxQueryParserHelper.parseQuery(params, pathInfo.substring("/console/riskpro".length()), UxConsoleConstants.QueryName.ConsoleHome) : (pathInfo.startsWith("/console") ? UxQueryParserHelper.parseQuery(params, pathInfo.substring("/console".length()), UxConsoleConstants.QueryName.ConsoleHome) : null))));
        if (query != null) {
            return query;
        }
        return new UxUnknownQuery(UxUnknownQueryMeta.Unknown, params.getRequestId(), params.getPathInfo());
    }

    @Nullable
    private static UxQuery parseQuery(UxServerRequestParams params, String pathInfo, UxConsoleConstants.QueryName appHome) throws UxQueryParserException {
        try {
            UxConsoleConstants.QueryName name;
            int pos;
            String queryName;
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            if (CdStringUtils.isNullOrBlank((String)(queryName = (pos = pathInfo.indexOf("/")) == -1 ? pathInfo : pathInfo.substring(0, pos)))) {
                name = appHome;
            } else {
                try {
                    name = UxConsoleConstants.QueryName.valueOf(queryName);
                }
                catch (IllegalArgumentException ex) {
                    throw new UxQueryParserException(ex, UxErrorCode.REQUEST_UNKNOWN, new Serializable[]{queryName});
                }
            }
            UxQueryParser parser = UxQueryParserRepository.lookupParser(name);
            if (parser != null) {
                return parser.parseQuery(params);
            }
            return null;
        }
        catch (RuntimeException ex) {
            throw new UxQueryParserException(ex, UxErrorCode.ERROR_UNEXPECTED, new Serializable[]{ex.getMessage()});
        }
    }
}

