/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.query;

import crazydev.common.exception.ICdException;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.embedded.IcCubeEngine;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.util.OlapOOM;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.filter.UxFilterValue;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.init.UxConsoleInitDataMissingReplyPayload;
import crazydev.iccube.ux.console.queries.lix.UxRegisterLixQueryMeta;
import crazydev.iccube.ux.console.queries.logout.UxLogoutQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxQuery {
    protected final UxQueryMeta meta;
    protected final OlapRequestId requestId;
    @Nullable
    private volatile CdVersion version;
    @Nullable
    private volatile OlapRequestVerbosity verbosity;
    @Nullable
    private String windowUId;
    @Nullable
    private String widgetUId;
    @Nullable
    private Long timestamp;

    public UxQuery(UxQueryMeta meta, OlapRequestId requestId) {
        this.meta = meta;
        this.requestId = requestId;
    }

    public OlapRequestId getRequestId() {
        return this.requestId;
    }

    public UxConsoleConstants.QueryName getQueryName() {
        return this.meta.queryName();
    }

    public UxQueryKind getKind() {
        return UxQueryKind.OTHER;
    }

    public String getInternalTypeName() {
        return this.getClass().getSimpleName();
    }

    public String getUserFriendlyTypeName() {
        return this.meta.queryName().name();
    }

    public String getTrackingInfo() {
        String kind = this.getKind().name();
        String schema = this.getSchemaName();
        String type = this.getClass().getSimpleName();
        String uuid = this.requestId.getClientUUID();
        return kind + " (" + (String)(schema != null ? "schema:" + schema : "schema:none") + ") " + type + " " + uuid;
    }

    public String getLoggerInfo() {
        return "[UX] request [" + this.getClass().getSimpleName() + "]";
    }

    public void setupMdxRequestProperties(OlapEngineRequestContext requestContext) {
    }

    protected boolean isAcceptedForMissing() {
        return false;
    }

    public boolean ignoreCSRFToken() {
        return false;
    }

    public boolean isMonitored() {
        return false;
    }

    public boolean isLoadMonitoring() {
        return false;
    }

    @Nullable
    public OlapChattyRequest isChattyRequest() {
        if (this.isLoadMonitoring()) {
            return OlapChattyRequest.loadMonitoringSchema;
        }
        return null;
    }

    @Nullable
    public OlapRequestVerbosity getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(@Nullable OlapRequestVerbosity verbosity) {
        this.verbosity = verbosity;
    }

    @Nullable
    public String getMdxForCancelReport() {
        return null;
    }

    public boolean isMonitoredForTimeout() {
        return false;
    }

    public boolean isSchemaLifeCycle() {
        return false;
    }

    @Nullable
    public String getSchemaLifeCycleName() {
        return null;
    }

    public boolean isForAllSchemas() {
        return false;
    }

    @Nullable
    public String getSchemaName() {
        return null;
    }

    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.NONE;
    }

    @Nullable
    public OlapFile getSchemaFactoryFileName(UxServerRequestContext context) {
        return null;
    }

    @Nullable
    public String getSchemaOfflineSnapshotName() {
        return null;
    }

    public boolean isCreateOfflineOnly() {
        return false;
    }

    public boolean isLoadSchema() {
        return false;
    }

    public boolean isFullLoadSchema() {
        return false;
    }

    public boolean isUnloadSchema() {
        return false;
    }

    public boolean isLoadPartitions() {
        return false;
    }

    public boolean isUnloadPartitions() {
        return false;
    }

    public boolean isLoadMeasureGroup() {
        return false;
    }

    public void initialize(UxServerRequestContext requestContext) {
    }

    public final UxReply execute(UxQueryContext queryContext) {
        boolean isLixMissing = queryContext.isMissing();
        if (isLixMissing && !this.isAcceptedForMissing()) {
            return this.executeForMissing(queryContext);
        }
        try {
            this.meta.assertAuthorized(queryContext);
            UxReply reply = this.executeQuery(queryContext);
            if (!queryContext.isForRestApi() && reply instanceof UxPayloadReply) {
                this.attachLicenseExpiryWarning(queryContext, (UxPayloadReply)reply);
                this.attachOOM(queryContext, (UxPayloadReply)reply);
                this.attachUseCaseAdditionalInfo(queryContext, (UxPayloadReply)reply);
                this.attachUseCase(queryContext, (UxPayloadReply)reply);
                this.attachUseCases(queryContext, (UxPayloadReply)reply);
                this.attachApps(queryContext, (UxPayloadReply)reply);
            }
            return reply;
        }
        catch (OlapRoleAuthorizationException | OlapRoleAuthorizationRuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] auth. error", ex);
            return UxReply.error(queryContext, ((ICdException)ex).getError());
        }
    }

    private UxReply executeForMissing(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        String appTitle = babylon.translate("appConsoleTitle", new Serializable[0]);
        String roleName = queryContext.getUserRoleName();
        String userName = queryContext.getUserName();
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        UxAction logout = UxLogoutQueryMeta.createAction(queryContext);
        if (logout != null) {
            actions.add(logout);
        }
        UxAction register = UxRegisterLixQueryMeta.createAction(queryContext);
        return UxReply.success(new UxConsoleInitDataMissingReplyPayload(appTitle, roleName, userName, actions, register));
    }

    protected abstract UxReply executeQuery(UxQueryContext var1);

    protected void attachLicenseExpiryWarning(UxQueryContext queryContext, UxPayloadReply reply) {
        if (IcCubeEngine.expiredUI != null) {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            reply.withLicenseExpiryWarning(babylon.translate("licenseExpiredWarning", IcCubeEngine.expiredUI));
        } else if (IcCubeEngine.expiryUI != null) {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            reply.withLicenseExpiryWarning(babylon.translate("licenseExpiryWarning", IcCubeEngine.expiryUI));
        }
    }

    protected void attachOOM(UxQueryContext queryContext, UxPayloadReply reply) {
        if (OlapOOM.oom) {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            reply.withOOM(babylon.translate("oom", new Serializable[0]));
        }
    }

    protected void attachUseCaseAdditionalInfo(UxQueryContext queryContext, UxPayloadReply reply) {
    }

    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
    }

    protected void attachUseCases(UxQueryContext queryContext, UxPayloadReply reply) {
    }

    protected void attachApps(UxQueryContext queryContext, UxPayloadReply reply) {
    }

    protected <ROW> List<ROW> filter(@Nullable UxTableOptions tableOptions, @Nullable UxTableRowSearcher searcher, @Nullable UxFilterMetas filterMetas, List<ROW> rows) {
        UxTableSearcher rowSearcher = this.setupRowSearcher(tableOptions, searcher);
        UxRowFilters rowFilters = this.setupRowFilters(tableOptions, filterMetas);
        if (rowSearcher == null && rowFilters == null) {
            return rows;
        }
        ArrayList<ROW> filteredRows = new ArrayList<ROW>();
        if (rows != null) {
            for (ROW row : rows) {
                if (rowSearcher != null && !rowSearcher.isAccepting(row) || rowFilters != null && !rowFilters.isAccepting(row)) continue;
                filteredRows.add(row);
            }
        }
        return filteredRows;
    }

    @Nullable
    public UxRowFilters setupRowFilters(@Nullable UxTableOptions tableOptions, @Nullable UxFilterMetas filterMetas) {
        if (tableOptions == null || filterMetas == null) {
            return null;
        }
        List<UxFilterValue> filters = tableOptions.getFilter();
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList<UxFilterMeta> filterMetas_ = new ArrayList<UxFilterMeta>();
        for (UxFilterValue filter : filters) {
            filterMetas_.add(filterMetas.getMeta(filter.getName()));
        }
        return new UxRowFilters(filterMetas_, filters);
    }

    @Nullable
    public UxTableSearcher setupRowSearcher(@Nullable UxTableOptions tableOptions, @Nullable UxTableRowSearcher searcher) {
        if (tableOptions == null || searcher == null) {
            return null;
        }
        String searchText = tableOptions.getSearchText();
        if (CdStringUtils.isNullOrBlank((String)searchText)) {
            return null;
        }
        return new UxTableSearcher(searchText, searcher);
    }

    protected static OlapPath setupOlapPath(@Nullable String path) {
        if (CdStringUtils.isNullOrBlank((String)path)) {
            return OlapPath.ROOT;
        }
        return OlapPath.createFromSimplePath((String)path);
    }

    protected static OlapPath setupOlapPath(@Nullable UxDocsEntryPath path) {
        if (path == null) {
            return OlapPath.ROOT;
        }
        return path.toOlapPath();
    }

    @Nullable
    public CdVersion getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable CdVersion version) {
        this.version = version;
    }

    public void setGviInfo(String windowUId, String widgetUId, Long timestamp) {
        this.windowUId = windowUId;
        this.widgetUId = widgetUId;
        this.timestamp = timestamp;
    }

    @Nullable
    public String getWindowUId() {
        return this.windowUId;
    }

    @Nullable
    public String getWidgetUId() {
        return this.widgetUId;
    }

    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }
}

