/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.model;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdClassUtils;
import crazydev.iccube.builder.OlapBuilderUxModel;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginClassProcessor;
import crazydev.iccube.ux.builder.common.UxBuilderPluginModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.plugin.UxBuilderPluginDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.plugin.UxBuilderPluginDataTableModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.plugin.UxBuilderPluginDataViewModelType;
import crazydev.iccube.ux.builder.queries.facts.modeltypes.plugin.UxBuilderPluginMeasureGroupModelType;
import crazydev.iccube.ux.common.model.UxModeTypeRepository;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UxModelTypePluginProcessor
implements OlapConfPluginClassProcessor {
    private final UxModeTypeRepository typeRepository;

    public UxModelTypePluginProcessor(UxModeTypeRepository typeRepository) {
        this.typeRepository = typeRepository;
    }

    public void onBegin() {
    }

    public void onClassRegistered(Class clazz) throws OlapConfigurationException {
        if (OlapBuilderBaseDataSource.class.isAssignableFrom(clazz)) {
            this.registerDataSource(clazz);
        } else if (OlapBuilderBaseDataTable.class.isAssignableFrom(clazz)) {
            this.registerDataTable(clazz);
        } else if (OlapBuilderBaseDataView.class.isAssignableFrom(clazz)) {
            this.registerDataView(clazz);
        } else if (OlapBuilderFacts.class.isAssignableFrom(clazz)) {
            this.registerFacts(clazz);
        } else if (OlapBuilderUxModel.class.isAssignableFrom(clazz)) {
            this.registerUxModel(clazz);
        }
    }

    private void registerUxModel(Class clazz) throws OlapConfigurationException {
        List<CdProperty> properties = this.getServerModelProperties(clazz);
        this.typeRepository.register(clazz.getSimpleName(), () -> new UxBuilderPluginModelType(clazz, properties));
    }

    private void registerDataSource(Class<? extends OlapBuilderBaseDataSource> clazz) throws OlapConfigurationException {
        List<CdProperty> properties = this.getServerModelProperties(clazz);
        this.typeRepository.register(clazz.getSimpleName(), () -> new UxBuilderPluginDataSourceModelType(clazz, properties));
    }

    private void registerDataTable(Class<? extends OlapBuilderBaseDataTable> clazz) throws OlapConfigurationException {
        List<CdProperty> properties = this.getServerModelProperties(clazz);
        this.typeRepository.register(clazz.getSimpleName(), () -> new UxBuilderPluginDataTableModelType(clazz, properties));
    }

    private void registerDataView(Class<? extends OlapBuilderBaseDataView> clazz) throws OlapConfigurationException {
        List<CdProperty> properties = this.getServerModelProperties(clazz);
        this.typeRepository.register(clazz.getSimpleName(), () -> new UxBuilderPluginDataViewModelType(clazz, properties));
    }

    private void registerFacts(Class<? extends OlapBuilderFacts> clazz) throws OlapConfigurationException {
        List<CdProperty> properties = this.getServerModelProperties(clazz);
        this.typeRepository.register(clazz.getSimpleName(), () -> new UxBuilderPluginMeasureGroupModelType(clazz, properties));
    }

    @NotNull
    private List<CdProperty> getServerModelProperties(Class<?> clazz) throws OlapConfigurationException {
        List<CdProperty> serverProperties = UxModelTypePluginProcessor.getServerModelDeclaredProperties(clazz);
        if (!serverProperties.isEmpty()) {
            return serverProperties;
        }
        return this.getServerModelPropertiesFromJaxbAnnotations(clazz);
    }

    private static List<CdProperty> getServerModelDeclaredProperties(Class<?> clazz) throws OlapConfigurationException {
        ArrayList classes = new ArrayList();
        URL originalPath = CdClassUtils.getClassLocation(clazz);
        do {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        } while (originalPath != null && originalPath.equals(CdClassUtils.getClassLocation(clazz)));
        ArrayList<CdProperty> properties = new ArrayList<CdProperty>();
        for (int ii = classes.size() - 1; ii >= 0; --ii) {
            UxModelTypePluginProcessor.getServerModelDeclaredProperties(properties, (Class)classes.get(ii));
        }
        return properties;
    }

    private static void getServerModelDeclaredProperties(List<CdProperty> properties, Class<?> serverModelClass) throws OlapConfigurationException {
        Field[] fields;
        for (Field field : fields = serverModelClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !CdProperty.class.isAssignableFrom(field.getType())) continue;
            try {
                Object property = field.get(null);
                properties.add((CdProperty)property);
            }
            catch (IllegalAccessException ex) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.CD_PROPERTY_ILLEGAL_ACCESS, new Serializable[]{field.toString()});
            }
        }
    }

    private List<CdProperty> getServerModelPropertiesFromJaxbAnnotations(Class<?> clazz) {
        Field[] serverModelFields;
        ArrayList<CdProperty> properties = new ArrayList<CdProperty>();
        for (Field serverModelField : serverModelFields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(serverModelField.getModifiers()) || serverModelField.getAnnotation(XmlTransient.class) != null) continue;
            serverModelField.setAccessible(true);
            properties.add((CdProperty)new CdReadWriteProperty(clazz, serverModelField.getName()));
        }
        properties.sort(Comparator.comparing(CdProperty::getName));
        return properties;
    }
}

