/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.model;

import crazydev.common.bean.IEmptyable;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdColumnRefs;
import crazydev.common.utils.CdEnumerableForUi;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdProperties;
import crazydev.common.utils.CdSql;
import crazydev.common.utils.CdStrings;
import crazydev.common.utils.CdUiEnums;
import crazydev.common.xml.CdPasswordXmlAdapter;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifier;
import crazydev.iccube.ux.admin.queries.completion.UxCompleteQueryMeta;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionType;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserNodeType;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserQueryMeta;
import crazydev.iccube.ux.builder.queries.tabulardata.UxTabularDataMetaHelper;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldEditorMeta;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.field.UxFieldTypeInfo;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.model.UxModelPropertyGroup;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class UxModelType<S> {
    private static Map<Class<?>, DefaultFieldTypeFactory> DEFAULTS = new HashMap();
    private final String persistentId;
    private final Class<S> serverModelClass;
    private final List<UxModelProperty> properties = new ArrayList<UxModelProperty>();

    protected UxModelType(String persistentId, Class<S> serverModelClass) {
        this.persistentId = persistentId;
        this.serverModelClass = serverModelClass;
    }

    private static void registerDefault(Class<?> clazz, UxFieldType type) {
        if (File.class.equals(clazz)) {
            DEFAULTS.put(clazz, (context, model, property) -> new UxFieldTypeInfo(type, UxFileChooserQueryMeta.createActionForFileSystem(context, UxFileChooserNodeType.File), null));
        } else {
            DEFAULTS.put(clazz, (context, model, property) -> new UxFieldTypeInfo(type));
        }
    }

    private static void registerDefault(Class<?> clazz, DefaultFieldTypeFactory factory) {
        DEFAULTS.put(clazz, factory);
    }

    public UxModelType setupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable S model) {
        this.doSetupProperties(context, modelOwner, model);
        this.orderProperties();
        return this;
    }

    protected void orderProperties() {
        this.properties.sort((o1, o2) -> {
            int g2;
            int g1 = o1.getGroup() != null ? o1.getGroup().getOrder() : -1;
            int gCmp = Integer.compare(g1, g2 = o2.getGroup() != null ? o2.getGroup().getOrder() : -1);
            if (gCmp != 0) {
                return gCmp;
            }
            return Integer.compare(o1.getDeclarationOrder(), o2.getDeclarationOrder());
        });
    }

    protected abstract void doSetupProperties(UxQueryContext var1, @Nullable Object var2, @Nullable S var3);

    public String getPersistentId() {
        return this.persistentId;
    }

    public Class<S> getServerModelClass() {
        return this.serverModelClass;
    }

    public S createEmptyServerModel() {
        try {
            Constructor<S> constructor = this.serverModelClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            if (obj instanceof IEmptyable) {
                obj = ((IEmptyable)obj).setupForEmptyModel();
            }
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException("internal error: could not create [" + this.serverModelClass.getName() + "]", ex);
        }
    }

    public List<UxModelProperty> getProperties() {
        return this.properties;
    }

    protected void addProperty(UxQueryContext context, CdProperty serverProperty, UxFieldTypeInfo type, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, null, serverProperty, type.type, type.completion, true, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, CdProperty serverProperty, UxFieldType type, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, null, serverProperty, type, null, true, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, type, null, true, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, boolean visible, boolean readOnly, boolean mandatory, Object defaultValue) {
        this.addProperty(context, group, serverProperty, null, type, null, null, null, true, visible, readOnly, mandatory, defaultValue);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, @Nullable UxFieldEditorMeta editorMeta, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, null, type, editorMeta, null, true, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, CdProperty serverProperty, UxFieldType type, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, null, serverProperty, type, null, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, type, null, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, CdProperty serverProperty, UxFieldType type, @Nullable UxAction completion, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, null, serverProperty, type, completion, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, CdProperty dependsOn, Enum dependsOnValue) {
        this.addProperty(context, group, serverProperty, type, dependsOn, dependsOnValue.name(), false);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, CdProperty dependsOn, String dependsOnValue, boolean mandatory) {
        this.addProperty(context, group, serverProperty, dependsOn, dependsOnValue, type, null, null, null, null, true, true, false, mandatory, null);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, @Nullable UxAction completion, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, null, type, completion, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, UxFieldType type, @Nullable UxAction completion, @Nullable List<UxAction> extraActions, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, null, type, null, completion, extraActions, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty serverPropertyDependsOn, UxFieldType type, @Nullable UxAction completion, @Nullable List<UxAction> extraActions, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, serverPropertyDependsOn, type, null, completion, extraActions, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty dependsOn, UxFieldType type, @Nullable UxAction completion, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, dependsOn, type, null, completion, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty dependsOn, UxFieldType type, @Nullable UxFieldEditorMeta editorMeta, @Nullable UxAction completion, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, dependsOn, type, editorMeta, completion, null, editable, visible, readOnly, mandatory);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty dependsOn, UxFieldType type, @Nullable UxFieldEditorMeta editorMeta, @Nullable UxAction completion, @Nullable List<UxAction> extraActions, boolean editable, boolean visible, boolean readOnly, boolean mandatory) {
        this.addProperty(context, group, serverProperty, dependsOn, type, editorMeta, completion, extraActions, editable, visible, readOnly, mandatory, null);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty dependsOn, UxFieldType type, @Nullable UxFieldEditorMeta editorMeta, @Nullable UxAction completion, @Nullable List<UxAction> extraActions, boolean editable, boolean visible, boolean readOnly, boolean mandatory, @Nullable Object defaultValue) {
        this.addProperty(context, group, serverProperty, dependsOn, type, editorMeta, null, completion, extraActions, editable, visible, readOnly, mandatory, defaultValue);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty dependsOn, UxFieldType type, @Nullable UxFieldEditorMeta editorMeta, @Nullable UxAction iAction, @Nullable UxAction completion, @Nullable List<UxAction> extraActions, boolean editable, boolean visible, boolean readOnly, boolean mandatory, @Nullable Object defaultValue) {
        this.addProperty(context, group, serverProperty, dependsOn, null, type, editorMeta, iAction, completion, extraActions, editable, visible, readOnly, mandatory, defaultValue);
    }

    protected void addProperty(UxQueryContext context, @Nullable String group, CdProperty serverProperty, @Nullable CdProperty dependsOn, @Nullable String dependsOnValue, UxFieldType type, @Nullable UxFieldEditorMeta editorMeta, @Nullable UxAction iAction, @Nullable UxAction completion, @Nullable List<UxAction> extraActions, boolean editable, boolean visible, boolean readOnly, boolean mandatory, @Nullable Object defaultValue) {
        UxBabylonService babylon = context.getUxBabylonService();
        String prefix = this.getPrefixForLocalization();
        String groupName = group;
        String groupCaption = group != null ? babylon.translate(groupName, new Serializable[0]) : null;
        UxHelpText groupDescription = group != null ? babylon.translateModelPropertyDescription(groupName) : null;
        Integer groupOrder = babylon.getOrder(groupName);
        String name = serverProperty.getName();
        String caption = !"description".equals(name) ? babylon.translateModelPropertyCaption(prefix, name) : babylon.translateModelPropertyCaption(null, name);
        UxHelpText description = babylon.translateModelPropertyDescription(prefix, name);
        this.addProperty(new UxModelProperty(serverProperty, this.properties.size(), UxModelPropertyGroup.create(groupName, groupCaption, groupDescription, groupOrder), new UxField(name, caption, description, new UxFieldMeta(type, editorMeta, iAction, completion, extraActions, editable, visible, readOnly, mandatory), new UxFieldValue(defaultValue), dependsOn != null ? dependsOn.getName() : null, dependsOnValue)));
    }

    protected String getPrefixForLocalization() {
        return this.getClass().getSimpleName();
    }

    protected void addProperty(UxModelProperty property) {
        this.properties.add(property);
    }

    protected static UxFieldTypeInfo getDefaultFieldType(UxQueryContext context, CdProperty property, @Nullable Object modelOwner, @Nullable Object model) {
        Class collType;
        UxBabylonService babylon = context.getUxBabylonService();
        Class clazz = property.getTypeForDefaultEditor();
        if (clazz.isArray()) {
            return new UxFieldTypeInfo(UxFieldTypes.CHECKBOXES(babylon, clazz.getComponentType()));
        }
        if (clazz.isEnum()) {
            return new UxFieldTypeInfo(UxFieldTypes.ENUM(babylon, clazz));
        }
        if (CdUiEnums.class.isAssignableFrom(clazz)) {
            Class enumClazz = property.getType();
            if (clazz == CdUiEnums.CdEnumSelect.class) {
                return new UxFieldTypeInfo(UxFieldTypes.ENUM(babylon, enumClazz));
            }
            if (clazz == CdUiEnums.CdEnumActionable.class) {
                return new UxFieldTypeInfo(UxFieldTypes.ACTIONABLE(babylon, enumClazz));
            }
            if (clazz == CdUiEnums.CdEnumRadio.class) {
                return new UxFieldTypeInfo(UxFieldTypes.RADIO(babylon, enumClazz));
            }
            throw new CdShouldNotBeHereProgrammingException(clazz.getName());
        }
        if (Locale.class.isAssignableFrom(clazz)) {
            return new UxFieldTypeInfo(UxFieldTypes.LOCALE(babylon));
        }
        if (CdEnumerableForUi.class.isAssignableFrom(clazz)) {
            List values = property.getPossibleValues(modelOwner, model);
            return new UxFieldTypeInfo(UxFieldTypes.ENUMERABLE(babylon, clazz, values));
        }
        if (List.class.isAssignableFrom(clazz) && (collType = property.getCollectionType()) == String.class) {
            return new UxFieldTypeInfo(UxFieldTypes.STRINGS_DUPLICATED);
        }
        if (OlapBuilderTabularDataXmlIdentifier.class.isAssignableFrom(clazz)) {
            String schemaName = context.getSchemaName();
            return new UxFieldTypeInfo(UxFieldTypes.STRING, UxCompleteQueryMeta.createAction(context, UxCompletionType.tableNames, schemaName), UxTabularDataMetaHelper.createExtraActions(context));
        }
        DefaultFieldTypeFactory factory = DEFAULTS.get(clazz);
        if (factory == null) {
            throw new RuntimeException("internal error: missing default field type for [" + clazz.getSimpleName() + "]");
        }
        UxFieldTypeInfo type = factory.create(context, model, property);
        return type;
    }

    static {
        UxModelType.registerDefault(Boolean.TYPE, UxFieldTypes.BOOLEAN);
        UxModelType.registerDefault(Boolean.class, UxFieldTypes.BOOLEAN);
        UxModelType.registerDefault(String.class, UxFieldTypes.STRING);
        UxModelType.registerDefault(URI.class, UxFieldTypes.URL);
        UxModelType.registerDefault(CdProperties.class, UxFieldTypes.TEXT);
        UxModelType.registerDefault(StringBuilder.class, UxFieldTypes.TEXT);
        UxModelType.registerDefault(Integer.TYPE, UxFieldTypes.INTEGER);
        UxModelType.registerDefault(Integer.class, UxFieldTypes.INTEGER);
        UxModelType.registerDefault(Long.TYPE, UxFieldTypes.LONG);
        UxModelType.registerDefault(Long.class, UxFieldTypes.LONG);
        UxModelType.registerDefault(CdPasswordXmlAdapter.class, UxFieldTypes.PASSWORD);
        UxModelType.registerDefault(LocalDate.class, UxFieldTypes.DATE);
        UxModelType.registerDefault(File.class, UxFieldTypes.FILE);
        UxModelType.registerDefault(DateTime.class, UxFieldTypes.DATE_TIME);
        UxModelType.registerDefault(LocalDateTime.class, UxFieldTypes.DATE_TIME);
        UxModelType.registerDefault(CdJson.class, UxFieldTypes.JSON);
        UxModelType.registerDefault(CdSql.class, UxFieldTypes.SQL);
        UxModelType.registerDefault(CdStrings.class, UxFieldTypes.STRINGS);
        UxModelType.registerDefault(CdColumnRefs.class, (UxQueryContext context, Object model, CdProperty property) -> {
            String schemaName = context.getSchemaName();
            String uuid = property.getTabularDataId(model);
            UxAction completion = UxCompleteQueryMeta.createAction(context, UxCompletionType.columnNames, schemaName, uuid);
            return new UxFieldTypeInfo(UxFieldTypes.STRINGS, completion, null);
        });
    }

    static interface DefaultFieldTypeFactory {
        public UxFieldTypeInfo create(UxQueryContext var1, @Nullable Object var2, CdProperty var3);
    }
}

