/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.model;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappings;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxModel
implements UxSerializable {
    private static final String TYPE_PERSISTENT_ID = "ic3_TypePersistentId";
    private static final String PERSISTENT_ID = "ic3_PersistentId";
    private static final String REV_NUMBER = "ic3_RevNumber";
    private static final String GROUP_INDEX = "ic3_GroupIndex";
    private final UxField[] fields;
    @Nullable
    private List<UxUseCase> usedBy;
    @Nullable
    private String usedByCaption;

    public UxModel(List<UxField> fields) {
        this(null, -1, 0, fields, null);
    }

    public UxModel(@Nullable String typePersistentId, int revNumber, int groupIndex, List<UxField> fields, @Nullable Boolean persistent) {
        UxField[] fields_ = new UxField[fields.size() + 1 + 1 + (typePersistentId != null ? 1 : 0) + (persistent != null && persistent != false ? 1 : 0)];
        for (int idx = 0; idx < fields.size(); ++idx) {
            fields_[idx] = fields.get(idx);
        }
        fields_[idx++] = new UxField(REV_NUMBER, REV_NUMBER, null, new UxFieldMeta(UxFieldTypes.INTEGER, false, true, true), new UxFieldValue(revNumber));
        fields_[idx++] = new UxField(GROUP_INDEX, GROUP_INDEX, null, new UxFieldMeta(UxFieldTypes.INTEGER, false, true, true), new UxFieldValue(groupIndex));
        if (typePersistentId != null) {
            fields_[idx++] = new UxField(TYPE_PERSISTENT_ID, TYPE_PERSISTENT_ID, null, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(typePersistentId));
        }
        if (persistent != null && persistent.booleanValue()) {
            fields_[idx++] = new UxField(PERSISTENT_ID, PERSISTENT_ID, null, new UxFieldMeta(UxFieldTypes.BOOLEAN, false, true, true), new UxFieldValue(true));
        }
        this.fields = fields_;
    }

    @Nullable
    public static UxModel fromJson(@Nullable Object json) {
        Map jModel;
        Object jFields;
        if (json instanceof Map && (jFields = (jModel = (Map)json).get("fields")) instanceof List) {
            ArrayList<UxField> fields = new ArrayList<UxField>();
            List jFields_ = (List)jFields;
            for (Object jField : jFields_) {
                if (!(jField instanceof Map)) continue;
                Map jField_ = (Map)jField;
                Object name = jField_.get("name");
                Object jValue = jField_.get("value");
                UxFieldValue value = null;
                if (jValue instanceof Map) {
                    Map jValue_ = (Map)jValue;
                    Object fValue = jValue_.get("value");
                    value = UxModel.isUxMappings(jField_) ? new UxFieldValue(UxFactsDimensionMappings.fromJson(fValue)) : new UxFieldValue(fValue);
                }
                fields.add(new UxField((String)name, "", null, null, value));
            }
            return new UxModel(fields);
        }
        return null;
    }

    private static boolean isUxMappings(Map<?, ?> field) {
        Map meta;
        Object type_;
        Object meta_ = field.get("meta");
        if (meta_ instanceof Map && (type_ = (meta = (Map)meta_).get("type")) instanceof Map) {
            Map type = (Map)type_;
            Object kind_ = type.get("kind");
            return UxFieldKind.DIM_MAPPINGS.name().equals(kind_);
        }
        return false;
    }

    public String getTypePersistentId() {
        String persistentId = null;
        for (UxField field : this.fields) {
            if (!TYPE_PERSISTENT_ID.equals(field.getName())) continue;
            UxFieldValue value = field.getValue();
            Object value_ = value.getValue();
            if (value_ == null) break;
            persistentId = value_.toString();
            break;
        }
        if (CdStringUtils.isNullOrBlank(persistentId)) {
            throw new RuntimeException("internal error: missing type persistent id");
        }
        return persistentId;
    }

    public boolean isPersistent() {
        for (UxField field : this.fields) {
            if (!PERSISTENT_ID.equals(field.getName())) continue;
            UxFieldValue value = field.getValue();
            Object value_ = value.getValue();
            if (value_ == null) break;
            return Boolean.valueOf(value_.toString());
        }
        return false;
    }

    public int getRevNumber() {
        int revNumber = -1;
        for (UxField field : this.fields) {
            int asInt;
            if (!REV_NUMBER.equals(field.getName())) continue;
            UxFieldValue value = field.getValue();
            Object value_ = value.getValue();
            if (value_ == null) break;
            double asDouble = Double.valueOf(value_.toString());
            if (asDouble != (double)(asInt = (int)asDouble)) {
                throw new RuntimeException("internal error: unexpected rev-number value [" + value_.toString() + "]");
            }
            revNumber = asInt;
            break;
        }
        return revNumber;
    }

    @Nullable
    public UxField getField(String name) {
        for (UxField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public void setUsedBy(String usedByCaption, @Nullable List<UxUseCase> usedBy) {
        this.usedByCaption = usedByCaption;
        this.usedBy = usedBy;
    }
}

