/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.model;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdPropertyHelper;
import crazydev.common.security.CdPassword;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationsDefinition;
import crazydev.iccube.authorizationx.definition.dashboards.IOlapRoleDashboardsDefinition;
import crazydev.iccube.authorizationx.definition.docs.IOlapRoleDocsDefinition;
import crazydev.iccube.authorizationx.definition.schemas.IOlapRoleSchemasDefinition;
import crazydev.iccube.builder.common.OlapBuilderCubeXmlIdentifier;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifier;
import crazydev.iccube.builder.common.OlapBuilderTabularDataXmlIdentifiers;
import crazydev.iccube.builder.common.OlapBuilderTypeUIXmlIdentifier;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.ux.meta.common.model.UxAutomodel;
import crazydev.iccube.configuration.component.plugins.OlapConfPluginClassProcessor;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.pub.principal.OlapInternalPrincipal;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertModelType;
import crazydev.iccube.ux.admin.queries.roles.UxRoleDefinitionModelType;
import crazydev.iccube.ux.admin.queries.scheduler.UxSchemaScheduleModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerContinuousTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerCronTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerDailyHoursTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerDailyTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerFixedRateTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerOnDataChangedTriggerModelType;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxSchedulerOnceTriggerModelType;
import crazydev.iccube.ux.admin.queries.tenants.UxTenantDefinitionModelType;
import crazydev.iccube.ux.admin.queries.users.UxUserDefinitionModelType;
import crazydev.iccube.ux.builder.queries.colors.modeltypes.UxBuilderSchemaColorsModelType;
import crazydev.iccube.ux.builder.queries.cube.modeltypes.UxBuilderCubeModelType;
import crazydev.iccube.ux.builder.queries.datacolumn.UxBuilderDataColumnModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.UxBuilderDataSourceNameFormModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.UxBuilderDataSourceTypeFormModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.files.UxBuilderCSVDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.files.UxBuilderFileDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.files.UxBuilderJsonDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderDb2JdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderMySqlJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderOracleJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderPostgresJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderRedshiftJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderSnowflakeJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderSqlAnywhereJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderSqlServerJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderSybaseJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderTrinoJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.jdbc.UxBuilderUrlJdbcDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.others.UxBuilderInMemoryDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.others.UxBuilderSpssDataSourceModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.plugin.UxBuilderGADataSourceAuthorizationTypeModelType;
import crazydev.iccube.ux.builder.queries.datasource.modeltypes.plugin.UxBuilderMongoDbConnectionTypeModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.UxBuilderDataSourceNameSelectorFormModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.UxBuilderDataSourceTableNamesFormModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.UxBuilderDataSourceTableTypeFormModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderCSVDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderFileLineDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderHttpCSVDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderHttpFileLineDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderJsonFileDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderJsonHttpDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderMultiFileJsonDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderMultiFileLineDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.files.UxBuilderMultiFilesCSVDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.jdbc.UxBuilderJdbcDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.jdbc.UxBuilderJdbcStatementDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.jdbc.UxBuilderJdbcUnionDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.others.UxBuilderInMemoryLineDataTableModelType;
import crazydev.iccube.ux.builder.queries.datatable.modeltypes.others.UxBuilderSpssDataTableModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.UxBuilderDataViewTypeFormModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.language.UxBuilderJavaDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.language.UxBuilderSimpleJavaDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.multi.UxBuilderJoinDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.multi.UxBuilderUnionDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderColsRowsDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderDumpDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderGroupByDataViewViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderParentChildSortDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderRenameDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderRowToColsDataViewModelType;
import crazydev.iccube.ux.builder.queries.dataview.modeltypes.single.UxBuilderSortDataViewModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderAdvancedDimensionModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderDimensionTypeSelectorFormModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderMultiLevelDimensionModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderParentChildDimensionModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderPathDimensionModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderSingleHierarchyModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderSingleHierarchyMultiTablesModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderStatisticalDimensionModelType;
import crazydev.iccube.ux.builder.queries.dimension.modeltypes.UxBuilderTimeWizardDimensionModelType;
import crazydev.iccube.ux.builder.queries.facts.modeltypes.UxBuilderMeasureGroupModelType;
import crazydev.iccube.ux.builder.queries.facts.modeltypes.UxBuilderMeasureGroupSetupTypeFormModelType;
import crazydev.iccube.ux.builder.queries.hierarchy.modeltypes.UxBuilderAdvancedHierarchyTypeSelectorFormModelType;
import crazydev.iccube.ux.builder.queries.hierarchy.modeltypes.UxBuilderMultiLevelHierarchyModelType;
import crazydev.iccube.ux.builder.queries.hierarchy.modeltypes.UxBuilderParentChildHierarchyModelType;
import crazydev.iccube.ux.builder.queries.hierarchy.modeltypes.UxBuilderPathHierarchyModelType;
import crazydev.iccube.ux.builder.queries.hierarchy.modeltypes.UxBuilderTimeWizardHierarchyModelType;
import crazydev.iccube.ux.builder.queries.level.modeltypes.UxBuilderHierarchyLevelModelType;
import crazydev.iccube.ux.builder.queries.level.modeltypes.UxBuilderMemberAttributeModelType;
import crazydev.iccube.ux.builder.queries.level.modeltypes.UxBuilderMemberPropertyModelType;
import crazydev.iccube.ux.builder.queries.level.modeltypes.UxBuilderTimeWizardHierarchyLevelModelType;
import crazydev.iccube.ux.builder.queries.localization.modeltypes.UxBuilderSchemaLocalizationModelType;
import crazydev.iccube.ux.builder.queries.measures.modeltypes.UxBuilderMeasureModelType;
import crazydev.iccube.ux.builder.queries.perspective.modeltypes.UxBuilderPerspectiveModelType;
import crazydev.iccube.ux.builder.queries.schema.modeltypes.UxBuilderSchemaCreatePropsModelType;
import crazydev.iccube.ux.builder.queries.schema.modeltypes.UxBuilderSchemaPropsModelType;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.field.UxFieldTypeInfo;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.model.UxModelType;
import crazydev.iccube.ux.common.model.UxModelTypePluginProcessor;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequest;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class UxModeTypeRepository {
    private final Map<String, TypeFactoryEx> factoriesPerId = new HashMap<String, TypeFactoryEx>();
    private final Map<Class<?>, TypeFactoryEx> factoriesPerServerModelClass = new HashMap();
    private final Object LOCK = new Object();

    public UxModeTypeRepository() {
        this.register(UxScheduledJobModelType.class);
        this.register(UxAlertModelType.class);
        this.register(UxSchemaScheduleModelType.class);
        this.register(UxSchedulerCronTriggerModelType.class);
        this.register(UxSchedulerContinuousTriggerModelType.class);
        this.register(UxSchedulerFixedRateTriggerModelType.class);
        this.register(UxSchedulerDailyTriggerModelType.class);
        this.register(UxSchedulerDailyHoursTriggerModelType.class);
        this.register(UxSchedulerOnceTriggerModelType.class);
        this.register(UxSchedulerOnDataChangedTriggerModelType.class);
        this.register(UxUserDefinitionModelType.class);
        this.register(UxRoleDefinitionModelType.class);
        this.register(UxTenantDefinitionModelType.class);
        this.register(UxBuilderSchemaPropsModelType.class);
        this.register(UxBuilderSchemaCreatePropsModelType.class);
        this.register(UxBuilderDataSourceTypeFormModelType.class);
        this.register(UxBuilderDataSourceNameFormModelType.class);
        this.register(UxBuilderDataSourceNameSelectorFormModelType.class);
        this.register(UxBuilderDataSourceTableTypeFormModelType.class);
        this.register(UxBuilderDataSourceTableNamesFormModelType.class);
        this.register(UxBuilderGADataSourceAuthorizationTypeModelType.class);
        this.register(UxBuilderMongoDbConnectionTypeModelType.class);
        this.register(UxBuilderInMemoryDataSourceModelType.class);
        this.register(UxBuilderDb2JdbcDataSourceModelType.class);
        this.register(UxBuilderMySqlJdbcDataSourceModelType.class);
        this.register(UxBuilderOracleJdbcDataSourceModelType.class);
        this.register(UxBuilderPostgresJdbcDataSourceModelType.class);
        this.register(UxBuilderRedshiftJdbcDataSourceModelType.class);
        this.register(UxBuilderSqlServerJdbcDataSourceModelType.class);
        this.register(UxBuilderSnowflakeJdbcDataSourceModelType.class);
        this.register(UxBuilderSqlAnywhereJdbcDataSourceModelType.class);
        this.register(UxBuilderSybaseJdbcDataSourceModelType.class);
        this.register(UxBuilderTrinoJdbcDataSourceModelType.class);
        this.register(UxBuilderUrlJdbcDataSourceModelType.class);
        this.register(UxBuilderFileDataSourceModelType.class);
        this.register(UxBuilderCSVDataSourceModelType.class);
        this.register(UxBuilderJsonDataSourceModelType.class);
        this.register(UxBuilderSpssDataSourceModelType.class);
        this.register(UxBuilderDataColumnModelType.class);
        this.register(UxBuilderInMemoryLineDataTableModelType.class);
        this.register(UxBuilderFileLineDataTableModelType.class);
        this.register(UxBuilderMultiFileLineDataTableModelType.class);
        this.register(UxBuilderCSVDataTableModelType.class);
        this.register(UxBuilderMultiFilesCSVDataTableModelType.class);
        this.register(UxBuilderJdbcDataTableModelType.class);
        this.register(UxBuilderJdbcUnionDataTableModelType.class);
        this.register(UxBuilderJdbcStatementDataTableModelType.class);
        this.register(UxBuilderHttpCSVDataTableModelType.class);
        this.register(UxBuilderHttpFileLineDataTableModelType.class);
        this.register(UxBuilderJsonFileDataTableModelType.class);
        this.register(UxBuilderMultiFileJsonDataTableModelType.class);
        this.register(UxBuilderJsonHttpDataTableModelType.class);
        this.register(UxBuilderSpssDataTableModelType.class);
        this.register(UxBuilderDataViewTypeFormModelType.class);
        this.register(UxBuilderColsRowsDataViewModelType.class);
        this.register(UxBuilderDumpDataViewModelType.class);
        this.register(UxBuilderGroupByDataViewViewModelType.class);
        this.register(UxBuilderRenameDataViewModelType.class);
        this.register(UxBuilderRowToColsDataViewModelType.class);
        this.register(UxBuilderSortDataViewModelType.class);
        this.register(UxBuilderParentChildSortDataViewModelType.class);
        this.register(UxBuilderUnionDataViewModelType.class);
        this.register(UxBuilderJoinDataViewModelType.class);
        this.register(UxBuilderJavaDataViewModelType.class);
        this.register(UxBuilderSimpleJavaDataViewModelType.class);
        this.register(UxBuilderMultiLevelDimensionModelType.class);
        this.register(UxBuilderSingleHierarchyModelType.class);
        this.register(UxBuilderSingleHierarchyMultiTablesModelType.class);
        this.register(UxBuilderParentChildDimensionModelType.class);
        this.register(UxBuilderPathDimensionModelType.class);
        this.register(UxBuilderTimeWizardDimensionModelType.class);
        this.register(UxBuilderStatisticalDimensionModelType.class);
        this.register(UxBuilderAdvancedDimensionModelType.class);
        this.register(UxBuilderDimensionTypeSelectorFormModelType.class);
        this.register(UxBuilderMultiLevelHierarchyModelType.class);
        this.register(UxBuilderPathHierarchyModelType.class);
        this.register(UxBuilderTimeWizardHierarchyModelType.class);
        this.register(UxBuilderParentChildHierarchyModelType.class);
        this.register(UxBuilderAdvancedHierarchyTypeSelectorFormModelType.class);
        this.register(UxBuilderHierarchyLevelModelType.class);
        this.register(UxBuilderTimeWizardHierarchyLevelModelType.class);
        this.register(UxBuilderMemberPropertyModelType.class);
        this.register(UxBuilderMemberAttributeModelType.class);
        this.register(UxBuilderCubeModelType.class);
        this.register(UxBuilderMeasureGroupModelType.class);
        this.register(UxBuilderMeasureGroupSetupTypeFormModelType.class);
        this.register(UxBuilderMeasureModelType.class);
        this.register(UxBuilderPerspectiveModelType.class);
        this.register(UxBuilderSchemaLocalizationModelType.class);
        this.register(UxBuilderSchemaColorsModelType.class);
    }

    private void register(Class<? extends UxModelType> clazz) {
        Constructor<? extends UxModelType> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("UX model type error: unexpected error for class [" + clazz.getName() + "]", ex);
        }
        this.register(clazz.getSimpleName(), () -> {
            try {
                return (UxModelType)constructor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("UX model type error: unexpected error for class [" + clazz.getName() + "]", ex);
            }
        });
    }

    protected void register(String name, TypeFactory factory) {
        try {
            UxModelType type = factory.create();
            String persistentId = type.getPersistentId();
            if (this.factoriesPerId.containsKey(persistentId)) {
                throw new RuntimeException("UX model type error: duplicated persistent id [" + persistentId + "] for [" + name + "]");
            }
            this.factoriesPerId.put(persistentId, (context, modelOwner, model) -> {
                try {
                    return factory.create().setupProperties(context, modelOwner, model);
                }
                catch (Exception ex) {
                    throw new RuntimeException("UX model type error: unexpected error for [" + name + "]", ex);
                }
            });
            Class serverModelClass = type.getServerModelClass();
            if (this.factoriesPerServerModelClass.containsKey(serverModelClass)) {
                throw new RuntimeException("UX model type error: duplicated server model class [" + String.valueOf(serverModelClass) + "] type [" + persistentId + "]");
            }
            this.factoriesPerServerModelClass.put(serverModelClass, (context, modelOwner, model) -> {
                try {
                    return factory.create().setupProperties(context, modelOwner, model);
                }
                catch (Exception ex) {
                    throw new RuntimeException("UX model type error: unexpected error for [" + name + "]", ex);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("UX model type error: unexpected error for [" + name + "]", ex);
        }
    }

    public OlapConfPluginClassProcessor createPluginClassProcessor() {
        return new UxModelTypePluginProcessor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertTypeConsistency(IcCubeServerApplicationContext applicationContext) {
        String sessionId = UUID.randomUUID().toString();
        OlapInternalPrincipal principal = new OlapInternalPrincipal("icCube", "administrator", Locale.ENGLISH);
        boolean sessionLess = false;
        OlapEngineSessionContext engineSessionContext = new OlapEngineSessionContext(applicationContext.getOlapEngineApplicationContext(), false, sessionId, (OlapPrincipal)principal);
        IcCubeServerSessionContext sessionContext = new IcCubeServerSessionContext(applicationContext, null, sessionId, engineSessionContext);
        try {
            OlapRequestId queryId = OlapRequestId.next((OlapRequestType)OlapRequestType.UNKNOWN);
            UxServerRequest request = new UxServerRequest(UxApi.UX, null, null, null, queryId, null, null);
            UxServerRequestContext requestContext = new UxServerRequestContext(sessionContext, request);
            UxQueryContext context = new UxQueryContext(this, requestContext){
                final /* synthetic */ UxModeTypeRepository this$0;
                {
                    UxModeTypeRepository uxModeTypeRepository = this$0;
                    Objects.requireNonNull(uxModeTypeRepository);
                    this.this$0 = uxModeTypeRepository;
                    super(requestContext);
                }

                @Override
                public UxBabylonService getUxBabylonService() {
                    return UxBabylonService.ENGLISH(UxApi.UX);
                }

                @Override
                public UxModeTypeRepository getUxModelTypeRepository() {
                    return this.this$0;
                }

                @Override
                public UxModelConverter getUxModelConverterFromServerModel(@Nullable Object modelOwner, Object model) {
                    Object type = this.this$0.createTypeFromServerModel(this, modelOwner, model);
                    return new UxModelConverter((UxModelType)type);
                }

                @Override
                public UxModelConverter getUxModelConverterFromUiModel(UxModel model) {
                    Object type = this.this$0.createTypeFromUiModel(this, model);
                    return new UxModelConverter((UxModelType)type);
                }
            };
            for (TypeFactoryEx factory : this.factoriesPerId.values()) {
                this.assertTypeConsistency(context, factory);
            }
        }
        finally {
            sessionContext.onDestroyed();
        }
    }

    private void assertTypeConsistency(UxQueryContext context, TypeFactoryEx factory) {
        UxModelType type = factory.create(context, null, null);
        List<UxModelProperty> properties = type.getProperties();
        for (UxModelProperty property : properties) {
            this.assertTypePropertyConsistency(context, type, property);
        }
    }

    private void assertTypePropertyConsistency(UxQueryContext context, UxModelType<?> type, UxModelProperty property) {
        Class<?> serverType = property.getServerType();
        UxFieldType uiType = property.getUiType();
        UxFieldKind uiKind = uiType.getKind();
        switch (uiKind) {
            case ACTIONABLE: {
                if (!serverType.isEnum() && serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case AVATAR: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case BOOLEAN: {
                if (serverType != Boolean.class && serverType != Boolean.TYPE) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case COLUMN_DEFS: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case CELL_PROPERTIES: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case DATE: {
                if (serverType != LocalDateTime.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case DIM_MAPPINGS: {
                return;
            }
            case DIRECTORY: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case ENUM: {
                if (!(serverType.isEnum() || Locale.class.isAssignableFrom(serverType) || String.class.isAssignableFrom(serverType))) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case FILE: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case GROUPED_ENUM: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case INTEGER: {
                if (serverType != Integer.class && serverType != Integer.TYPE) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case JAVA: 
            case JAVASCRIPT: 
            case JSON: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case LONG: {
                if (serverType != Long.class && serverType != Long.TYPE) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case MDX: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case MODEL: {
                if (serverType.isPrimitive() || serverType.isArray() || Collection.class.isAssignableFrom(serverType) || Map.class.isAssignableFrom(serverType)) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case MODELS: {
                if (!List.class.isAssignableFrom(serverType)) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case PASSWORD: {
                if (serverType != CdPassword.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case PASSWORD_HASH: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case RADIO: {
                if (!serverType.isEnum() && serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case ROLE_APPLICATIONS: {
                if (serverType != OlapRoleApplicationsDefinition.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case ROLE_SCHEMAS: {
                if (serverType != IOlapRoleSchemasDefinition.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case ROLE_DASHBOARDS: {
                if (serverType != IOlapRoleDashboardsDefinition.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case ROLE_DOCS: {
                if (serverType != IOlapRoleDocsDefinition.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case SQL: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case STRING: {
                if (serverType != String.class && serverType != OlapBuilderTypeUIXmlIdentifier.class && serverType != OlapBuilderTabularDataXmlIdentifier.class && serverType != OlapBuilderCubeXmlIdentifier.class && serverType != OlapBuilderDataColumnRef.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case CHECKBOXES: {
                if (!List.class.isAssignableFrom(serverType)) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case STRINGS: 
            case STRINGS_DUPLICATED: {
                if (!List.class.isAssignableFrom(serverType) && serverType != OlapBuilderTabularDataXmlIdentifiers.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case TABLE_NAME: {
                if (!OlapBuilderTabularDataXmlIdentifier.class.isAssignableFrom(serverType)) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case TEXT: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case URL: {
                if (serverType != String.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
            case VALIDATION: {
                if (serverType != UxValidationResult.class) {
                    UxModeTypeRepository.onError(type, property, serverType, uiKind);
                }
                return;
            }
        }
        throw new RuntimeException("UX model type error: unexpected property type [" + String.valueOf(uiKind) + "]");
    }

    private static void onError(UxModelType<?> type, UxModelProperty property, Class<?> serverType, UxFieldKind uiKind) {
        throw new RuntimeException("UX model type [" + type.getClass().getSimpleName() + "] error: unexpected " + String.valueOf(uiKind) + " property [" + property.getName() + "] type [" + serverType.getSimpleName() + "]");
    }

    public <T extends UxModelType> T createTypeFromUiModel(UxQueryContext context, UxModel model) {
        String persistentId = model.getTypePersistentId();
        TypeFactoryEx factory = this.factoriesPerId.get(persistentId);
        if (factory == null) {
            throw new RuntimeException("UX model type error: missing type for id [" + persistentId + "]");
        }
        return (T)factory.create(context, null, null);
    }

    public <T extends UxModelType> T createTypeFromServerModel(UxQueryContext context, @Nullable Object modelOwner, Object model) {
        Class<?> clazz = model.getClass();
        return this.createTypeFromServerModelClass(context, clazz, modelOwner, model);
    }

    public <T extends UxModelType> T createTypeFromServerModelClass(UxQueryContext context, Class<?> clazz) {
        return this.createTypeFromServerModelClass(context, clazz, null, null);
    }

    public <T extends UxModelType> T createTypeFromServerModelClass(UxQueryContext context, Class<?> clazz, @Nullable Object modelOwner, @Nullable Object model) {
        TypeFactoryEx factory = this.factoriesPerServerModelClass.get(clazz);
        if (factory == null) {
            if (model instanceof UxAutomodel) {
                return this.createUxModelFromProperties(context, modelOwner, model);
            }
            throw new RuntimeException("UX model type error: missing type for class [" + clazz.getName() + "]");
        }
        return (T)factory.create(context, modelOwner, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends UxModelType> T createUxModelFromProperties(UxQueryContext context, @Nullable Object modelOwner, @NotNull Object model) {
        Object object = this.LOCK;
        synchronized (object) {
            String name = model.getClass().getName();
            TypeFactoryEx instance = UxModeTypeRepository.createUxModel(model, name);
            this.factoriesPerId.put(name, instance);
            this.factoriesPerServerModelClass.put(model.getClass(), instance);
            return (T)instance.create(context, modelOwner, model);
        }
    }

    private static TypeFactoryEx createUxModel(final Object model, String uxName) {
        final List properties = CdPropertyHelper.getAllDeclaredPropertiesAsList(model.getClass());
        if (properties.isEmpty()) {
            throw new RuntimeException("Can not create a UxModel from an empty model " + model.getClass().getName());
        }
        return (context, modelOwner, fakeModel) -> {
            UxModelType modelType = new UxModelType(uxName, model.getClass()){

                protected void doSetupProperties(UxQueryContext context, @Nullable Object modelOwner, @Nullable Object fakeModel) {
                    if (fakeModel != null && fakeModel != model) {
                        throw new RuntimeException("Inconsistency issue " + model.getClass().getName() + " -> " + fakeModel.getClass().getName());
                    }
                    properties.forEach(property -> {
                        UxFieldTypeInfo type = UxModelType.getDefaultFieldType(context, property, null, model);
                        this.addProperty(context, (CdProperty)property, type, property.isVisibleInUi(), property.isReadOnlyInUi(), property.isMandatoryInUI());
                    });
                }

                public Object createEmptyServerModel() {
                    return super.createEmptyServerModel();
                }
            };
            modelType.setupProperties(context, null, model);
            return modelType;
        };
    }

    public static interface TypeFactory {
        public UxModelType create();
    }

    @FunctionalInterface
    private static interface TypeFactoryEx {
        public UxModelType create(UxQueryContext var1, @Nullable Object var2, @Nullable Object var3);
    }
}

