/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.filter;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.filter.UxFilterValue;
import org.jetbrains.annotations.Nullable;

public enum UxFilterKind implements UxSerializable
{
    CONTAINS{

        @Override
        public boolean isAccepting(UxFilterValue filter, @Nullable Object value) {
            String valueStr;
            String filteringValueStr;
            String[] filteringValues = filter.getValue();
            if (filteringValues == null || filteringValues.length == 0) {
                filteringValueStr = null;
            } else if (filteringValues.length == 1) {
                String filteringValue = filteringValues[0];
                filteringValueStr = CdStringUtils.isNotNullAndNotBlank((String)filteringValue) ? filteringValue : null;
            } else {
                return false;
            }
            if (value == null) {
                valueStr = null;
            } else {
                String value_ = value.toString();
                String string = valueStr = CdStringUtils.isNotNullAndNotBlank((String)value_) ? value_ : null;
            }
            if (filteringValueStr == null || valueStr == null) {
                return filteringValueStr == valueStr;
            }
            return valueStr.toUpperCase().contains(filteringValueStr.toUpperCase());
        }
    }
    ,
    ENUM{

        @Override
        public boolean isAccepting(UxFilterValue filter, @Nullable Object value) {
            String valueStr;
            String[] filteringValues = filter.getValue();
            boolean isNonNull = false;
            if (filteringValues != null) {
                for (String filteringValue : filteringValues) {
                    if (!CdStringUtils.isNotNullAndNotBlank((String)filteringValue)) continue;
                    isNonNull = true;
                    break;
                }
            }
            if (value == null) {
                valueStr = null;
            } else {
                String value_ = value.toString();
                String string = valueStr = CdStringUtils.isNotNullAndNotBlank((String)value_) ? value_ : null;
            }
            if (!isNonNull) {
                return null == valueStr;
            }
            if (valueStr == null) {
                return false;
            }
            for (String filteringValue : filteringValues) {
                if (!CdStringUtils.isNotNullAndNotBlank((String)filteringValue) || !valueStr.equalsIgnoreCase(filteringValue)) continue;
                return true;
            }
            return false;
        }
    };


    public abstract boolean isAccepting(UxFilterValue var1, @Nullable Object var2);
}

