/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.model.UxModels;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class UxModelsFieldType
extends UxFieldType {
    private final UxModel proto;
    private final boolean create;
    private final boolean delete;
    private final boolean order;
    @Nullable
    private final String selector;

    UxModelsFieldType(UxModel prototype, boolean create, boolean delete, boolean order, @Nullable String selector) {
        super(UxFieldKind.MODELS);
        this.proto = prototype;
        this.create = create;
        this.delete = delete;
        this.order = order;
        this.selector = selector;
    }

    @Override
    public Object convertToUiModelValue(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, UxModelProperty property, @Nullable Object serverValue) {
        if (serverValue instanceof List) {
            List serverBeans = (List)serverValue;
            UxModel[] uiModels = new UxModel[serverBeans.size()];
            for (int ii = 0; ii < serverBeans.size(); ++ii) {
                Object serverBean = serverBeans.get(ii);
                uiModels[ii] = context.convertToUxModel(-1, lock, serverModel, serverBean, null);
            }
            return new UxModels(uiModels);
        }
        return serverValue;
    }

    @Override
    public Object convertToServerModelValue(UxQueryContext context, UxModelProperty property, @Nullable Object uiValue) {
        if (uiValue == null) {
            return null;
        }
        UxModels uiModels = UxModels.fromJson(uiValue);
        if (uiModels == null) {
            throw new RuntimeException("models field [" + property.getName() + "] type mismatch : " + String.valueOf(uiValue));
        }
        UxModel[] models = uiModels.getModels();
        if (models == null || models.length == 0) {
            return null;
        }
        ArrayList serverBeans = new ArrayList();
        for (UxModel model : models) {
            Object serverBean = context.convertToServerModel(model);
            serverBeans.add(serverBean);
        }
        return serverBeans;
    }
}

