/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.model.UxModelPropertyGroup;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxField
implements UxSerializable {
    @Nullable
    private final UxModelPropertyGroup group;
    private final String name;
    private final String caption;
    @Nullable
    private final UxHelpText description;
    private final UxFieldMeta meta;
    private final UxFieldValue value;
    @Nullable
    private final String dependsOn;
    @Nullable
    private final String dependsOnValue;

    public UxField(UxBabylonService babylon, String name, UxFieldMeta meta, UxFieldValue value) {
        this(null, name, babylon.translate(name, new Serializable[0]), babylon.translateWizardDescription(name), meta, value, null, null);
    }

    public UxField(String name, String caption, @Nullable UxHelpText description, UxFieldMeta meta, UxFieldValue value) {
        this(null, name, caption, description, meta, value, null, null);
    }

    public UxField(String name, String caption, @Nullable UxHelpText description, UxFieldMeta meta, UxFieldValue value, @Nullable String dependsOn) {
        this(null, name, caption, description, meta, value, dependsOn, null);
    }

    public UxField(String name, String caption, @Nullable UxHelpText description, UxFieldMeta meta, UxFieldValue value, @Nullable String dependsOn, @Nullable String dependsOnValue) {
        this(null, name, caption, description, meta, value, dependsOn, dependsOnValue);
    }

    public UxField(@Nullable UxModelPropertyGroup group, String name, String caption, @Nullable UxHelpText description, UxFieldMeta meta, UxFieldValue value, @Nullable String dependsOn, @Nullable String dependsOnValue) {
        this.group = group;
        this.name = name;
        this.caption = caption;
        this.description = description;
        this.meta = meta;
        this.value = value;
        this.dependsOn = dependsOn;
        this.dependsOnValue = dependsOnValue;
    }

    public boolean isMandatory() {
        return this.meta.isMandatory();
    }

    public String getName() {
        return this.name;
    }

    public UxFieldMeta getMeta() {
        return this.meta;
    }

    public UxFieldValue getValue() {
        return this.value;
    }

    public UxField withValue(Object value) {
        return new UxField(this.group, this.name, this.caption, this.description, this.meta, new UxFieldValue(value), this.dependsOn, this.dependsOnValue);
    }

    public UxField withGroup(@Nullable UxModelPropertyGroup group) {
        if (group == null) {
            return this;
        }
        return new UxField(group, this.name, this.caption, this.description, this.meta, new UxFieldValue(this.value), this.dependsOn, this.dependsOnValue);
    }

    public String toString() {
        return this.name + " (" + String.valueOf(this.value.getValue()) + ")";
    }
}

