/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.action;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxActionBuilder {
    private final UxQueryContext context;
    private final UxQueryMeta query;
    @Nullable
    private UxSchemaId schemaId;
    private int placement;
    private String id;
    private int attrs;
    private String caption;
    private String captionEx;
    private String captionSearch;
    private String title;
    @Nullable
    private String synopsis;
    @Nullable
    private String processingInfo;
    @Nullable
    private String noticeText;
    private boolean okCancel;
    private String okCancelParam;
    private String okCancelMessage;
    private String rawUrl;
    private UxUrl url;
    private UxField[] params;
    private UxActionContinuation continuation;
    @Nullable
    private UxAction progressInfo;
    @Nullable
    private Integer progressInfoRefreshS;
    @Nullable
    private UxAction progressContinuation;
    private Boolean replyAttached;
    private UxUseCase useCase;

    public UxActionBuilder(UxQueryContext context, UxQueryMeta query) {
        this.context = context;
        this.query = query;
        if (query instanceof UxSchemaBuilderQueryMeta) {
            throw new RuntimeException("internal error: use the constructor with UxSchemaBuilderQueryMeta parameter");
        }
    }

    public UxActionBuilder(UxQueryContext context, UxSchemaBuilderQueryMeta query, UxSchemaId schemaId) {
        this.context = context;
        this.query = query;
        this.schemaId = schemaId;
        if (schemaId == null) {
            throw new RuntimeException("internal error: missing UxSchemaId parameter");
        }
    }

    public UxActionBuilder withPlacement(int placement) {
        this.placement |= placement;
        return this;
    }

    public UxActionBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public UxActionBuilder withAttrs(int attrs) {
        this.attrs |= attrs;
        return this;
    }

    public UxActionBuilder withCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public UxActionBuilder withCaptionEx(String captionEx) {
        this.captionEx = captionEx;
        return this;
    }

    public UxActionBuilder withCaptionSearch(String captionSearch) {
        this.captionSearch = captionSearch;
        return this;
    }

    public UxActionBuilder withOkCancel() {
        this.okCancel = true;
        return this;
    }

    public UxActionBuilder withOkCancelWithParam(String param) {
        this.okCancel = true;
        this.okCancelParam = param;
        return this;
    }

    public UxActionBuilder withOkCancel(String message) {
        this.okCancel = true;
        this.okCancelMessage = message;
        return this;
    }

    public UxActionBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public UxActionBuilder withSynopsis(String synopsis) {
        this.synopsis = synopsis;
        return this;
    }

    public UxActionBuilder withProcessingInfo(String processingInfo) {
        this.processingInfo = processingInfo;
        return this;
    }

    public UxActionBuilder withRawUrl(String url) {
        this.rawUrl = url;
        return this;
    }

    public UxActionBuilder withUrl(UxUrl url) {
        this.url = url;
        return this;
    }

    public UxActionBuilder withContinuation(UxActionContinuationKind continuation) {
        this.continuation = new UxActionContinuation(continuation);
        return this;
    }

    public UxActionBuilder withContinuation(@Nullable UxUseCase continuation) {
        this.continuation = continuation == null ? null : new UxActionContinuation(UxActionContinuationKind.NAVIGATE, continuation);
        return this;
    }

    public UxActionBuilder withProgressInfo(UxAction progressInfo, int progressInfoRefreshS, UxAction progressContinuation) {
        this.progressInfo = progressInfo;
        this.progressInfoRefreshS = progressInfoRefreshS;
        this.progressContinuation = progressContinuation;
        return this;
    }

    public UxActionBuilder withReplyAttached(Boolean replyAttached) {
        this.replyAttached = replyAttached;
        return this;
    }

    public UxActionBuilder withParams(UxField ... params) {
        this.params = params;
        return this;
    }

    public UxActionBuilder withUseCase(UxUseCase useCase) {
        this.useCase = useCase;
        return this;
    }

    public UxAction build() {
        if (!this.query.isAuthorized(this.context)) {
            return null;
        }
        if (this.placement == 0) {
            this.placement = 2;
        }
        if (this.id == null) {
            this.id = this.query.queryName().name();
        }
        UxBabylonService babylon = this.context.getUxBabylonService();
        if (this.caption == null) {
            this.caption = babylon.translateActionCaption(this.id, new Serializable[0]);
        }
        if (this.captionEx == null) {
            this.captionEx = babylon.translateActionCaptionEx(this.id, new Serializable[0]);
        }
        if (this.captionSearch == null) {
            this.captionSearch = babylon.translateActionCaptionSearch(this.id, new Serializable[0]);
        }
        if (this.title == null) {
            this.title = babylon.translateActionTitle(this.id, new Serializable[0]);
        }
        if (this.synopsis == null) {
            this.synopsis = babylon.translateActionSynopsis(this.id, new Serializable[0]);
        }
        if (this.processingInfo == null) {
            this.processingInfo = babylon.translateActionProcessingInfo(this.id, new Serializable[0]);
        }
        if (this.noticeText == null) {
            this.noticeText = babylon.translateActionNoticeText(this.id, new Serializable[0]);
        }
        String okCancel_ = null;
        if (this.okCancel) {
            okCancel_ = CdStringUtils.isNullOrBlank((String)this.okCancelMessage) ? babylon.translateActionOkCancel(this.id, new Serializable[]{CdStringUtils.isNotNullAndNotBlank((String)this.okCancelParam) ? " (" + this.okCancelParam + ")" : ""}) : this.okCancelMessage;
        }
        if (this.url == null) {
            this.url = this.query instanceof UxSchemaBuilderQueryMeta ? ((UxSchemaBuilderQueryMeta)this.query).createQueryUrl(this.schemaId) : this.query.createQueryUrl();
        }
        if (this.replyAttached == null) {
            this.replyAttached = this.query.isReplyAttached();
        }
        if (this.continuation == null) {
            this.continuation = new UxActionContinuation(UxActionContinuationKind.REFRESH);
        }
        if (this.useCase != null) {
            this.url = this.useCase.url();
        }
        if (this.query.isFileUpload()) {
            this.attrs |= 1;
        }
        if (this.query.isValidateSchemaDef()) {
            this.attrs |= 0x10;
        }
        if (this.query.isDeploySchemaDef()) {
            this.attrs |= 0x20;
        }
        if (this.query.isDeployAndLoadSchemaDef()) {
            this.attrs |= 0x40;
        }
        if (this.query.isCreate()) {
            this.attrs |= 2;
        }
        if (this.query.isRefresh()) {
            this.attrs |= 4;
        }
        return new UxAction(this.placement, this.id, this.attrs, this.caption, this.captionEx, this.captionSearch, this.title, this.synopsis, this.processingInfo, this.noticeText, okCancel_, this.rawUrl, this.url, this.params, this.progressInfo, this.progressInfoRefreshS, this.progressContinuation, this.replyAttached, this.continuation, this.useCase);
    }
}

