/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.service;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.revision.CdVFileRev;
import crazydev.common.fs.revision.CdVFileRevFolder;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.factory.schema.OlapBuilderBaseSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.type.MemberPropertyConsistencyCheckType;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaCreateProps;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaCache;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaCacheStats;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaInfo;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaLockKind;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaProcessor;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaRepository;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaRepositoryHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class UxBuilderSchemaService {
    private final String tenantDebug;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final UxBuilderSchemaRepository repository;
    private final UxBuilderSchemaCache cache;

    public UxBuilderSchemaService(String tenantDebug, OlapDirectoriesResolved directories, OlapBuilderMetaInformationRepository metaInformation) {
        this.tenantDebug = tenantDebug;
        this.repository = new UxBuilderSchemaRepository(directories, metaInformation);
        this.cache = new UxBuilderSchemaCache(this.repository);
        OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " async. init. cache started"));
        try {
            String threadName = "ux-builder-cache" + OlapTenant.info((OlapTenant)this.repository.getTenant());
            new Thread(() -> this.refreshCache(false), threadName).start();
        }
        catch (RuntimeException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder]" + this.repository.getTenantInfo() + " async. init. cache error"), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T processForWrite(Processor<T> processor) {
        OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] processForWrite: started");
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lockInterruptibly();
        }
        catch (InterruptedException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " schema service write interrupted"), (Throwable)ex);
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_SVC_WRITE_INTERRUPTED, (Serializable[])new Serializable[0]));
        }
        OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] processForWrite: processing");
        try {
            T t = processor.process();
            return t;
        }
        finally {
            writeLock.unlock();
            OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] processForWrite: completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T processForRead(Processor<T> processor) {
        ReentrantReadWriteLock.WriteLock readLock = this.lock.writeLock();
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " schema service read interrupted"), (Throwable)ex);
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_SVC_WRITE_INTERRUPTED, (Serializable[])new Serializable[0]));
        }
        try {
            T t = processor.process();
            return t;
        }
        finally {
            readLock.unlock();
        }
    }

    public void refreshCache(boolean refreshMetaInformation) {
        this.processForWrite(() -> {
            this.cache.refresh();
            return null;
        });
        if (refreshMetaInformation) {
            this.repository.refreshMetaInformation();
        }
    }

    public void removeSchemaDefinition(UxSchemaId schemaId) {
        this.processForWrite(() -> {
            this.cache.removeSchemaDefinition(schemaId);
            return null;
        });
    }

    public UxBuilderSchemaCacheStats cacheStats() {
        return this.processForRead(this.cache::stats);
    }

    @Nullable
    public CdVFileRevFolder getRevDirectory(String relPath) {
        return this.processForRead(() -> this.repository.getRevDirectory(relPath));
    }

    public void forEachRevDirectory(Consumer<CdVFileRevFolder> consumer) {
        this.processForRead(() -> {
            this.repository.forEachRevDirectory(consumer);
            return null;
        });
    }

    public UxBuilderSchemaInfo restoreRevDirectory(String savedBy, String relPath) {
        return this.processForWrite(() -> {
            UxBuilderSchema restoredSchema = this.repository.restoreRevDirectory(savedBy, relPath);
            this.cache.onSchemaRestored(restoredSchema);
            String restoredSchemaName = restoredSchema.getName();
            File restoredSchemaFile = restoredSchema.getFactory().getXmlFile();
            return new UxBuilderSchemaInfo(restoredSchemaName, restoredSchemaFile);
        });
    }

    public void forEachSchemaShortInfo(Predicate<OlapSchemaFactoryInfo> consumer) {
        this.processForRead(() -> {
            this.repository.forEachSchemaShortInfo(consumer);
            return null;
        });
    }

    @Nullable
    public String getSchemaName(UxSchemaId schemaId) {
        if (CdStringUtils.isNotNullAndNotBlank((String)schemaId.schemaName)) {
            return schemaId.schemaName;
        }
        OlapSchemaFactoryInfo info = this.processForRead(() -> {
            try {
                File file = UxBuilderSchemaRepositoryHelper.createBuilderFile(this.repository.getVfs(), this.repository.getBuilderDirectory(), schemaId.schemaFile);
                return this.repository.getSchemaShortInfo(file, false);
            }
            catch (RuntimeException ex) {
                OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] could not retrieve the schema name " + String.valueOf(schemaId)), (Throwable)ex);
                return null;
            }
        });
        if (info != null) {
            return info.getName();
        }
        return null;
    }

    public OlapSchemaFactoryInfo getSchemaShortInfo(UxSchemaId schemaId, boolean withDef) {
        return this.processForRead(() -> {
            OlapSchemaFactoryInfo info = this.repository.getSchemaShortInfo(schemaId, withDef);
            if (info == null) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_UNKNOWN, (Serializable[])new Serializable[]{schemaId.asErrorInfo()}));
            }
            return info;
        });
    }

    public <R> R readSchema(UxSchemaId schemaId, int revNumber, UxBuilderSchemaProcessor<R> processor) {
        return this.readSchema(schemaId, revNumber, false, processor);
    }

    public <R> R readSchemaClone(UxSchemaId schemaId, int revNumber, UxBuilderSchemaProcessor<R> processor) {
        return this.readSchema(schemaId, revNumber, true, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R readSchema(UxSchemaId schemaId, int revNumber, boolean clone, UxBuilderSchemaProcessor<R> processor) {
        UxBuilderSchema schema = this.getSchema(schemaId, revNumber, clone);
        Lock readLock = schema.readLock();
        try {
            readLock.lockInterruptibly();
        }
        catch (InterruptedException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " schema read interrupted [" + schema.getName() + "]"), (Throwable)ex);
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_READ_INTERRUPTED, (Serializable[])new Serializable[]{schema.getName()}));
        }
        try {
            R r = processor.process(new UxBuilderSchemaLock(UxBuilderSchemaLockKind.READ, schema), schema);
            return r;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R writeSchema(UxSchemaId schemaId, int revNumber, UxBuilderSchemaProcessor<R> processor) {
        UxBuilderSchema schema = this.getSchema(schemaId, revNumber, false);
        Lock writeLock = schema.writeLock();
        try {
            writeLock.lockInterruptibly();
        }
        catch (InterruptedException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " schema write interrupted [" + schema.getName() + "]"), (Throwable)ex);
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_WRITE_INTERRUPTED, (Serializable[])new Serializable[]{schema.getName()}));
        }
        try {
            R r = processor.process(new UxBuilderSchemaLock(UxBuilderSchemaLockKind.WRITE, schema), schema);
            return r;
        }
        finally {
            writeLock.unlock();
        }
    }

    private UxBuilderSchema getSchema(UxSchemaId schemaId, int expectedRevNumber, boolean clone) {
        return this.processForRead(() -> this.getSchemaUnsafe(schemaId, expectedRevNumber, clone));
    }

    private UxBuilderSchema getSchemaUnsafe(UxSchemaId schemaId, int expectedRevNumber, boolean clone) {
        int revNumber;
        UxBuilderSchema schema = this.cache.getSchemaEx(schemaId);
        if (schema == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_UNKNOWN, (Serializable[])new Serializable[]{schemaId.asErrorInfo()}));
        }
        if (expectedRevNumber != -1 && expectedRevNumber != (revNumber = schema.getRevNumber())) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_REV_NUMBER_MISMATCH, (Serializable[])new Serializable[]{schemaId.asErrorInfo(), Integer.valueOf(revNumber), Integer.valueOf(expectedRevNumber)}));
        }
        if (clone) {
            try {
                OlapBuilderSchemaDefFactory schemaDef = new OlapBuilderSchemaDefFactory(schema.getDefinition(new UxBuilderSchemaLock(UxBuilderSchemaLockKind.READ, schema)));
                OlapBuilderSchemaDefFactory schemaDefClone = this.repository.copySchemaDef(schemaDef);
                schema = new UxBuilderSchema((OlapBuilderBaseSchemaDefFactory)schemaDefClone);
            }
            catch (Exception ex) {
                OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " schema [" + schema.getName() + "] copy error"), (Throwable)ex);
                throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_COPY_ERROR, (Serializable[])new Serializable[]{schema.getName(), ex.getMessage()}));
            }
        }
        return schema;
    }

    public OlapSchemaFactoryInfo saveSchemaForCreate(String savedBy, UxBuilderSchemaCreateProps props) {
        OlapBuilderSchemaDefFactory factory = new OlapBuilderSchemaDefFactory();
        OlapBuilderSchema definition = factory.getSchemaDefinition();
        props.update(definition);
        definition.memberPropertyConsistencyCheck_(MemberPropertyConsistencyCheckType.ACTIVE);
        definition.setMembersUpperLowerCaseStrategy(MembersUpperLowerStrategyType.getDefault());
        UxBuilderSchema createdSchema = new UxBuilderSchema((OlapBuilderBaseSchemaDefFactory)factory);
        return this.processForWrite(() -> {
            if (this.repository.isExisting(createdSchema.getName())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_EXISTING, (Serializable[])new Serializable[]{createdSchema.getName()}));
            }
            UxBuilderSchemaLock lock = new UxBuilderSchemaLock(UxBuilderSchemaLockKind.READ, createdSchema);
            this.repository.saveSchemaDefForCreate(savedBy, lock, createdSchema);
            this.cache.onSchemaCreated(createdSchema);
            OlapSchemaFactoryInfo info = createdSchema.getInfo();
            return info;
        });
    }

    public UxBuilderSchemaInfo saveSchemaDefForUpload(String savedBy, String fileName, UxServerRequestParams params) {
        return this.processForWrite(() -> {
            UxBuilderSchema uploadedSchema = this.repository.unmarshallSchemaDefForUpload(fileName, params);
            UxBuilderSchemaLock lock = new UxBuilderSchemaLock(UxBuilderSchemaLockKind.READ, uploadedSchema);
            this.repository.saveSchemaDefForUpload(savedBy, lock, uploadedSchema);
            this.cache.onSchemaUploaded(uploadedSchema);
            String schemaName = uploadedSchema.getName();
            File factoryFile = uploadedSchema.getFactory().getXmlFile();
            return new UxBuilderSchemaInfo(schemaName, factoryFile);
        });
    }

    public void saveSchemaDefForXmlEdition(String savedBy, UxSchemaId schemaId, String content) {
        this.processForWrite(() -> {
            OlapSchemaFactoryInfo schema = this.repository.getSchemaShortInfo(schemaId, false);
            if (schema == null) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_UNKNOWN, (Serializable[])new Serializable[]{schemaId.asErrorInfo()}));
            }
            UxBuilderSchema editedSchema = this.repository.unmarshallSchemaDefXmlEdition(schema.getName(), content);
            if (!schema.getName().equals(editedSchema.getName())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_RENAME, (Serializable[])new Serializable[]{schema.getName(), editedSchema.getName()}));
            }
            UxBuilderSchemaLock lock = new UxBuilderSchemaLock(UxBuilderSchemaLockKind.READ, editedSchema);
            OlapBuilderBaseSchemaDefFactory factory = editedSchema.getFactory();
            factory.setXmlFile(schema.getFile());
            this.repository.saveSchemaDefForXmlEdition(savedBy, lock, editedSchema);
            this.cache.onSchemaXmlEdited(editedSchema);
            return null;
        });
    }

    public void saveSchemaDefForDuplicate(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema schema, String dupSchemaName, @Nullable String dupSchemaDescription, @Nullable String dupSchemaGroup) {
        if (schema.getName().equals(dupSchemaName)) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DUPLICATE, (Serializable[])new Serializable[]{schema.getName(), schema.getName()}));
        }
        this.processForWrite(() -> {
            if (this.repository.isExisting(dupSchemaName)) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_EXISTING, (Serializable[])new Serializable[]{dupSchemaName}));
            }
            lock.assertForWriteAccess(schema);
            File file = schema.getFactory().getXmlFile();
            UxBuilderSchema duplicatedSchema = this.repository.saveSchemaDefForDuplicate(savedBy, file, dupSchemaName, dupSchemaDescription, dupSchemaGroup);
            this.cache.onSchemaDuplicated(duplicatedSchema);
            return null;
        });
    }

    public void saveSchemaDefForBookmark(UxBuilderSchemaLock lock, UxBuilderSchema schema, String savedBy, String bookmark) {
        lock.assertForWriteAccess(schema);
        this.processForWrite(() -> {
            try {
                this.repository.saveSchemaDefForBookmark(lock, schema, savedBy, bookmark);
            }
            catch (RuntimeException ex) {
                this.cache.onSchemaSaved(schema, true);
                throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_SAVE_ERROR, (Serializable[])new Serializable[]{schema.getName(), ex.getMessage()}));
            }
            this.cache.onSchemaSaved(schema, false);
            return null;
        });
    }

    public void saveSchemaDef(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema schema, String operation) {
        lock.assertForWriteAccess(schema);
        this.processForWrite(() -> {
            try {
                this.repository.saveSchemaDef(savedBy, lock, schema, operation);
            }
            catch (RuntimeException ex) {
                this.cache.onSchemaSaved(schema, true);
                throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_SAVE_ERROR, (Serializable[])new Serializable[]{schema.getName(), ex.getMessage()}));
            }
            this.cache.onSchemaSaved(schema, false);
            return null;
        });
    }

    public void forEachSchemaDefRevisions(UxBuilderSchemaLock lock, UxBuilderSchema schema, Consumer<CdVFileRev> consumer) {
        lock.assertForReadAccess(schema);
        this.processForRead(() -> {
            this.repository.forEachSchemaRevision(lock, schema, consumer);
            return null;
        });
    }

    public CdVFileRev getSchemaDefRevision(UxBuilderSchemaLock lock, UxBuilderSchema schema, String revFileName, boolean withPayload) {
        lock.assertForReadAccess(schema);
        return this.processForRead(() -> this.repository.getSchemaRevision(lock, schema, revFileName, withPayload));
    }

    public void restoreSchemaDefRevision(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema schema, String revFileName) {
        lock.assertForWriteAccess(schema);
        this.processForWrite(() -> {
            UxBuilderSchema restoredSchema = this.repository.restoreSchemaRevision(savedBy, lock, schema, revFileName);
            this.cache.onSchemaRestored(restoredSchema);
            return null;
        });
    }

    public void bookmarkSchemaDefRevision(UxBuilderSchemaLock lock, UxBuilderSchema schema, String revFileName, String bookmark) {
        lock.assertForWriteAccess(schema);
        this.processForWrite(() -> {
            this.repository.bookmarkSchemaRevision(lock, schema, revFileName, bookmark);
            return null;
        });
    }

    public void deleteSchema(UxSchemaId schemaId) {
        this.processForWrite(() -> {
            this.repository.deleteSchema(schemaId);
            this.cache.onSchemaDeleted(schemaId);
            return null;
        });
    }

    public static String validateSchemaDefinition(OlapBuilderMetaInformationRepository metaInformation, String content) throws JAXBException {
        Class[] classes = metaInformation.getPersistentClasses();
        StringReader reader = new StringReader(content);
        OlapBuilderBaseSchemaDefFactory definition = (OlapBuilderBaseSchemaDefFactory)CdXmlUtils.unmarshall(null, (Reader)reader, (Class[])classes);
        StringWriter writer = new StringWriter();
        CdXmlUtils.marshall((Writer)writer, (Object)definition, (Class[])classes);
        return writer.toString();
    }

    public static <T> T duplicateDefinition(OlapBuilderMetaInformationRepository metaInformation, T bean) throws JAXBException, IOException {
        Class[] classes = metaInformation.getPersistentClasses();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bytes, StandardCharsets.UTF_8));
        CdXmlUtils.marshall((Writer)writer, bean, (Class[])classes);
        ((Writer)writer).close();
        String xml = bytes.toString(StandardCharsets.UTF_8.name());
        Object duplicated = CdXmlUtils.unmarshall((String)xml, (Class[])classes);
        return (T)duplicated;
    }

    @FunctionalInterface
    private static interface Processor<T> {
        public T process();
    }
}

