/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.wizarddef;

import com.google.gson.Gson;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.ux.meta.common.model.UxModelPropertyFilter;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardProps;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardUuidProp;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datatable.wizard.UxBuilderCreateDataTableWizard;
import crazydev.iccube.builder.ux.meta.dataview.wizard.UxBuilderCreateDataViewWizard;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderCreateDimensionWizard;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderCreateMeasureGroupWizard;
import crazydev.iccube.builder.ux.meta.hierarchy.wizard.UxBuilderCreateHierarchyWizard;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefStep;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardLastStep;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.json.UxJsonUtils;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class UxWizardDef
implements UxSerializable {
    private final String id = UUID.randomUUID().toString();
    private final String useCaseTitle;
    @Nullable
    private final UxBuilderWizardProps props;
    private final List<UxWizardDefStep> steps;
    private final UxWizardLastStep lastStep;
    @Nullable
    private final UxAction validate;

    public UxWizardDef(String useCaseTitle, UxBuilderWizardProps props, List<UxWizardDefStep> steps, UxWizardLastStep lastStep, @Nullable UxAction validate) {
        this.useCaseTitle = useCaseTitle;
        this.props = props;
        this.steps = steps;
        this.lastStep = lastStep;
        this.validate = validate;
    }

    public static UxBuilderCreateDataSourceWizard setupCreateDataSourceWizardFromJson(UxQueryContext context, @Nullable Object props, int activeStep, Object stepDefs, Object stepModels) {
        UxBuilderWizardProps wProps = UxWizardDef.setupWizardPropsFromJson(props);
        List<UxBuilderWizardStep> steps = UxWizardDef.setupWizardFromJson(context, activeStep, stepDefs, stepModels);
        return new UxBuilderCreateDataSourceWizard(wProps, steps);
    }

    public static UxBuilderCreateDataTableWizard setupCreateDataTableWizardFromJson(UxQueryContext context, @Nullable Object props, int activeStep, Object stepDefs, Object stepModels) {
        UxBuilderWizardProps wProps = UxWizardDef.setupWizardPropsFromJson(props);
        List<UxBuilderWizardStep> steps = UxWizardDef.setupWizardFromJson(context, activeStep, stepDefs, stepModels);
        return new UxBuilderCreateDataTableWizard(wProps, steps);
    }

    public static UxBuilderCreateDataViewWizard setupCreateDataViewWizardFromJson(UxQueryContext context, @Nullable Object props, int activeStep, Object stepDefs, Object stepModels) {
        List<UxBuilderWizardStep> steps = UxWizardDef.setupWizardFromJson(context, activeStep, stepDefs, stepModels);
        return new UxBuilderCreateDataViewWizard(steps);
    }

    public static UxBuilderCreateMeasureGroupWizard setupCreateMeasureGroupWizardFromJson(UxQueryContext context, @Nullable Object props, int activeStep, Object stepDefs, Object stepModels) {
        UxBuilderWizardProps wProps = UxWizardDef.setupWizardPropsFromJson(props);
        List<UxBuilderWizardStep> steps = UxWizardDef.setupWizardFromJson(context, activeStep, stepDefs, stepModels);
        return new UxBuilderCreateMeasureGroupWizard(wProps, steps);
    }

    public static UxBuilderCreateHierarchyWizard setupCreateHierarchyWizardFromJson(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable Object props, int activeStep, Object stepDefs, Object stepModels) {
        UxBuilderWizardProps wProps = UxWizardDef.setupWizardPropsFromJson(props);
        if (wProps == null) {
            throw new UxQueryExpectedException(UxErrorCode.BUILDER_HIERARCHY_WIZARD_ERROR, new Serializable[]{"missing props"});
        }
        UxBuilderWizardUuidProp dimensionName = wProps.getUuidProperty("dimensionName");
        if (dimensionName == null) {
            throw new UxQueryExpectedException(UxErrorCode.BUILDER_HIERARCHY_WIZARD_ERROR, new Serializable[]{"missing props.dimensionName"});
        }
        IOlapBuilderDimensionDef dimension = schema.getExistingDimension(lock, UxBuilderDimensionUniqueName.create(dimensionName));
        UxBuilderCreateHierarchyWizard wizard = dimension.setupCreateHierarchyWizard();
        if (wizard == null) {
            throw new UxQueryExpectedException(UxErrorCode.BUILDER_HIERARCHY_WIZARD_ERROR, new Serializable[]{"could not create the wizard"});
        }
        List<UxBuilderWizardStep> steps = UxWizardDef.setupWizardFromJson(context, activeStep, stepDefs, stepModels);
        wizard.setSteps(steps);
        return wizard;
    }

    public static UxBuilderCreateDimensionWizard setupCreateDimensionWizardFromJson(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable Object props, int activeStep, Object stepDefs, Object stepModels) {
        UxBuilderWizardProps wProps = UxWizardDef.setupWizardPropsFromJson(props);
        List<UxBuilderWizardStep> steps = UxWizardDef.setupWizardFromJson(context, activeStep, stepDefs, stepModels);
        return new UxBuilderCreateDimensionWizard(wProps, steps);
    }

    @Nullable
    private static UxBuilderWizardProps setupWizardPropsFromJson(@Nullable Object props) {
        if (props == null) {
            return null;
        }
        Gson gson = UxJsonUtils.gson().create();
        String json = gson.toJson(props);
        UxBuilderWizardProps wProps = (UxBuilderWizardProps)gson.fromJson(json, UxBuilderWizardProps.class);
        return wProps;
    }

    private static List<UxBuilderWizardStep> setupWizardFromJson(UxQueryContext context, int activeStep, Object stepDefs, Object stepModels) {
        List<UxBuilderWizardStep> steps = UxWizardDef.setupStepsFromJson(context, activeStep, (List)stepDefs);
        Map jsonStepModels = (Map)stepModels;
        for (int idx = 0; idx < steps.size(); ++idx) {
            Object jsonStepModel = jsonStepModels.get(String.valueOf(idx));
            if (jsonStepModel == null) continue;
            UxBuilderWizardStep step = steps.get(idx);
            UxModel stepModelUI = UxModel.fromJson(jsonStepModel);
            Object model = context.convertToServerModel(stepModelUI, step.getModelProps());
            step.setModel(model);
        }
        return steps;
    }

    private static List<UxBuilderWizardStep> setupStepsFromJson(UxQueryContext context, int activeStep, List stepDefs) {
        int stepCount = activeStep == -1 ? stepDefs.size() : activeStep + 1;
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        for (int idx = 0; idx < stepCount; ++idx) {
            Map stepDef = (Map)stepDefs.get(idx);
            String id = (String)stepDef.get("id");
            UxModelPropertyFilter props = UxModelPropertyFilter.fromJson(stepDef.get("modelProps"));
            steps.add(new UxBuilderWizardStep(id, props));
        }
        return steps;
    }
}

