/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.type;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.queries.type.UxBuilderTypeDef;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxBuilderTypeDefQuery
extends UxBuilderQuery {
    static final Map<String, Class<? extends Enum>> MAPPING = new HashMap<String, Class<? extends Enum>>();
    @Nullable
    private final String type;

    public UxBuilderTypeDefQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String type) {
        super(meta, requestId);
        this.type = type;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        if (CdStringUtils.isNullOrBlank((String)this.type)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_TYPE_NOT_FOUND, (Serializable[])new Serializable[]{"<null>"}));
        }
        Class<? extends Enum> eType = MAPPING.get(this.type);
        if (eType == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_TYPE_NOT_FOUND, (Serializable[])new Serializable[]{this.type}));
        }
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxFieldType type = UxFieldTypes.ENUM(babylon, eType);
        UxBuilderTypeDef result = new UxBuilderTypeDef(type);
        return UxReply.actionSuccess(result);
    }

    static {
        MAPPING.put(OlapAggregationType.class.getSimpleName(), OlapAggregationType.class);
        MAPPING.put(OlapBuilderInputType.class.getSimpleName(), OlapBuilderInputType.class);
    }
}

