/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.tabulardata;

import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;

public class UxTabularDataQuery
extends UxSchemaBuilderQuery {
    private final String uuid;

    public UxTabularDataQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String uuid) {
        super(meta, requestId, schemaId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxUseCase continuation;
            IOlapBuilderTabularDataDef data = schema.getExistingTabularDataByUUID(lock, this.uuid);
            if (data instanceof IOlapBuilderDataViewDef) {
                IOlapBuilderDataViewDef view = (IOlapBuilderDataViewDef)data;
                continuation = UxDataViewQueryMeta.createUseCase(queryContext, this.schemaId, this.schemaId.schemaName, view.getId(), view.getName(), view.getHelpUrl());
            } else {
                UxBuilderTableReference table = schema.getExistingDataTableByUUID(lock, this.uuid);
                continuation = UxDataTableQueryMeta.createUseCase(queryContext, this.schemaId, this.schemaId.schemaName, table.table.getId(), table.uniqueName());
            }
            return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE_EXTERNAL, continuation));
        });
    }
}

