/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.structure;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderTableReference;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.reply.payload.UxReplyPayload;
import crazydev.iccube.ux.common.url.UxUrl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UxStructureOverviewReplyPayload
extends UxReplyPayload {
    private final List<Node> nodes;

    public UxStructureOverviewReplyPayload(List<Node> nodes) {
        this.nodes = nodes;
    }

    public static void add(Map<String, Node> maps, UxSchemaId schemaId, UxBuilderTableReference table, UxAction ... uxActions) {
        UxUrl useCaseURL = UxStructureOverviewReplyPayload.asBookmarkUrl(UxDataTableQueryMeta.DataTable.createQueryUrl(schemaId, table.uniqueName()));
        Node node = new Node(NodeType.T, table.getTableId(), table.getTableName(), table.getTableDescription(), useCaseURL);
        node.addAction(uxActions);
        maps.put(table.getTableId(), node);
    }

    public static void add(Map<String, Node> maps, UxSchemaId schemaId, IOlapBuilderDataViewDef view, UxAction ... uxActions) {
        UxUrl useCaseURL = UxStructureOverviewReplyPayload.asBookmarkUrl(UxDataViewQueryMeta.DataView.createQueryUrl(schemaId, view.getName()));
        Node node = new Node(NodeType.V, view.getId(), view.getName(), view.getDescription(), useCaseURL);
        List internalTabularDataIds = view.getInternalTabularDataIds();
        internalTabularDataIds.forEach(id -> node.dependencies.add((String)id));
        node.addAction(uxActions);
        maps.put(view.getId(), node);
    }

    public static void add(Map<String, Node> maps, UxSchemaId schemaId, IOlapBuilderDimensionDef dim, UxAction ... uxActions) {
        if (CdStringUtils.isNotNullAndNotBlank((String)dim.getDefinedTableId())) {
            UxUrl useCaseURL = UxStructureOverviewReplyPayload.asBookmarkUrl(UxDimensionQueryMeta.Dimension.createQueryUrl(schemaId, UxBuilderDimensionUniqueName.create(dim)));
            String nodeId = "Dim-" + dim.getName();
            Node node = new Node(NodeType.D, nodeId, dim.getName(), "", useCaseURL);
            node.dependencies.add(dim.getDefinedTableId());
            node.addAction(uxActions);
            maps.put(nodeId, node);
        }
    }

    public static void add(Map<String, Node> maps, UxSchemaId schemaId, UxBuilderMeasureGroupReference measGroup, boolean multipleCubes, UxAction ... uxActions) {
        if (measGroup.measureGroup != null && CdStringUtils.isNotNullAndNotBlank((String)measGroup.measureGroup.getDataTableId())) {
            UxUrl useCaseURL = UxStructureOverviewReplyPayload.asBookmarkUrl(UxMeasureGroupQueryMeta.MeasureGroup.createQueryUrl(schemaId, measGroup.uniqueName()));
            String nodeName = (String)(multipleCubes ? measGroup.getCubeName() + ":" : "") + measGroup.measureGroup.getMeasureGroupName();
            String nodeId = "MG-" + nodeName;
            Node node = new Node(NodeType.MG, nodeId, nodeName, "", useCaseURL);
            node.dependencies.add(measGroup.measureGroup.getDataTableId());
            node.addAction(uxActions);
            maps.put(nodeId, node);
        }
    }

    private static UxUrl asBookmarkUrl(UxUrl url) {
        return UxAdminUseCaseRepository.asBookmark(url);
    }

    static class Node {
        final NodeType type;
        final String nodeId;
        final String name;
        final String description;
        final List<String> dependencies = new ArrayList<String>();
        final UxUrl useCaseURL;
        final List<UxAction> actions = new ArrayList<UxAction>();
        boolean isUsed;

        public Node(NodeType type, String nodeId, String name, String description, UxUrl useCaseURL) {
            this.type = type;
            this.nodeId = nodeId;
            this.name = name;
            this.description = description;
            this.useCaseURL = useCaseURL;
        }

        public void addAction(UxAction ... uxActions) {
            for (int i = 0; uxActions != null && i < uxActions.length; ++i) {
                UxAction uxAction = uxActions[i];
                if (uxAction == null) continue;
                this.actions.add(uxAction);
            }
        }
    }

    static enum NodeType {
        T,
        V,
        D,
        MG;

    }
}

