/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.structure;

import crazydev.common.collection.CdPair;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.queries.datatable.analyse.UxTableAnalyseQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTableBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.structure.UxStructureOverviewReplyPayload;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UxStructureOverviewQuery
extends UxSchemaBuilderQuery {
    public UxStructureOverviewQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            HashMap<String, UxStructureOverviewReplyPayload.Node> maps = new HashMap<String, UxStructureOverviewReplyPayload.Node>();
            schema.forEachTable(lock, table -> {
                UxAction browse = UxTableBrowseQueryMeta.createActionForTable(queryContext, this.schemaId, table.uniqueName());
                UxAction analyze = UxTableAnalyseQueryMeta.createActionForTable(queryContext, this.schemaId, table.uniqueName());
                UxStructureOverviewReplyPayload.add((Map<String, UxStructureOverviewReplyPayload.Node>)maps, this.schemaId, table, browse, analyze);
            });
            schema.forEachView(lock, view -> {
                UxAction browse = UxTableBrowseQueryMeta.createActionForView(queryContext, this.schemaId, view.getName());
                UxAction analyze = UxTableAnalyseQueryMeta.createActionForView(queryContext, this.schemaId, view.getName());
                UxStructureOverviewReplyPayload.add((Map<String, UxStructureOverviewReplyPayload.Node>)maps, this.schemaId, view, browse, analyze);
            });
            schema.forEachDimension(lock, dim -> {
                UxAction browse = UxDimensionBrowseQueryMeta.createAction(queryContext, this.schemaId, UxBuilderDimensionUniqueName.create(dim));
                UxStructureOverviewReplyPayload.add((Map<String, UxStructureOverviewReplyPayload.Node>)maps, this.schemaId, dim, browse);
            });
            schema.forEachMeasureGroups(lock, measGroup -> UxStructureOverviewReplyPayload.add((Map<String, UxStructureOverviewReplyPayload.Node>)maps, this.schemaId, measGroup, schema.getSortedCubes(lock).size() > 1, new UxAction[0]));
            ArrayList links = new ArrayList();
            maps.forEach((s, node) -> node.dependencies.forEach(id -> links.add(new CdPair((Object)node.nodeId, id))));
            maps.forEach((s, node) -> {
                if (node.type == UxStructureOverviewReplyPayload.NodeType.MG || node.type == UxStructureOverviewReplyPayload.NodeType.D) {
                    node.isUsed = true;
                    this.markAsUsedRecursive((Map<String, UxStructureOverviewReplyPayload.Node>)maps, (Set<String>)new HashSet<String>(), (UxStructureOverviewReplyPayload.Node)node);
                }
            });
            return UxReply.success(new UxStructureOverviewReplyPayload(new ArrayList<UxStructureOverviewReplyPayload.Node>(maps.values())));
        });
    }

    private void markAsUsedRecursive(Map<String, UxStructureOverviewReplyPayload.Node> maps, Set<String> visitedNodes, UxStructureOverviewReplyPayload.Node node) {
        visitedNodes.add(node.nodeId);
        node.dependencies.forEach(parentId -> {
            UxStructureOverviewReplyPayload.Node parent = (UxStructureOverviewReplyPayload.Node)maps.get(parentId);
            if (parent != null && !visitedNodes.contains(parent.nodeId)) {
                parent.isUsed = true;
                this.markAsUsedRecursive(maps, visitedNodes, parent);
            }
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.StructureOverview, this.schemaId));
    }
}

