/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.script;

import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderScriptDef;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.admin.queries.runtime.request.UxEditRequestMdxQueryMeta;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.script.UxSchemaScriptValidator;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxFileRevNumber;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.util.HashMap;

public class UxSaveSchemaScriptQuery
extends UxSchemaBuilderQuery {
    private final String fileContent;
    private final int revNumber;

    protected UxSaveSchemaScriptQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String fileContent, int revNumber) {
        super(meta, requestId, schemaId);
        this.fileContent = fileContent;
        this.revNumber = revNumber;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.revNumber, (lock, schema) -> {
            OlapBuilderScript script = new OlapBuilderScript(this.fileContent);
            OlapBuilderSchema schemaDef = schema.getDefinition(lock);
            queryContext.setupForScriptValidation();
            UxValidationResult errors = UxSchemaScriptValidator.validate(queryContext, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderScriptDef)script);
            if (errors != null && errors.hasErrors()) {
                return UxReply.validationErrors(errors, UxSaveSchemaScriptQuery.createSynopsisForValidation(queryContext, schema), UxSaveSchemaScriptQuery.createDockNameForValidation(schema));
            }
            schema.setScript(lock, script, true);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "edit script");
            HashMap<String, UxSerializable> extra = new HashMap<String, UxSerializable>();
            extra.put("schemaValidationSuccessful", (UxSerializable)UxValidationResult.createForClearValidation(UxSaveSchemaScriptQuery.createDockNameForValidation(schema)));
            UxAction runScript = UxEditRequestMdxQueryMeta.createAction(queryContext, schema.getName(), this.fileContent);
            if (runScript != null) {
                extra.put("refreshAction", runScript);
            }
            return UxReply.actionSuccess(extra, new UxFileRevNumber(schema.getRevNumber()));
        });
    }
}

