/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.schema.UxSchemaValidator;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.util.HashMap;

public class UxValidateSchemaDefQuery
extends UxSchemaBuilderQuery {
    protected UxValidateSchemaDefQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        service.removeSchemaDefinition(this.schemaId);
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxValidationResult errors = UxSchemaValidator.validate(queryContext, (IOlapBuilderSchemaDefFactory)schema.getFactory());
            if (errors != null && errors.hasErrors()) {
                return UxReply.validationErrors(errors, UxValidateSchemaDefQuery.createSynopsisForValidation(queryContext, schema), UxValidateSchemaDefQuery.createDockNameForValidation(schema));
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "validate schema");
            HashMap<String, UxSerializable> extra = new HashMap<String, UxSerializable>();
            extra.put("schemaValidationSuccessful", (UxSerializable)UxValidationResult.createForClearValidation(UxValidateSchemaDefQuery.createDockNameForValidation(schema)));
            return UxReply.actionSuccess(extra);
        });
    }
}

