/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.init.UxSchemaBuilderHomeQueryMeta;
import crazydev.iccube.ux.builder.queries.schema.UxSearchSchemaDefs;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSearchSchemaDefsQuery
extends UxBuilderQuery {
    public static final int MAX = 25;
    @Nullable
    private final String searchText;

    protected UxSearchSchemaDefsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String searchText) {
        super(meta, requestId);
        this.searchText = searchText;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        ArrayList schemas = new ArrayList();
        if (CdStringUtils.isNotNullAndNotBlank((String)this.searchText)) {
            UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
            service.forEachSchemaShortInfo(schema -> {
                String description;
                String group;
                String name = schema.getName();
                if (UxSearchSchemaDefsQuery.isAccepted(this.searchText, name, group = schema.getGroup(), description = schema.getDescription())) {
                    schemas.add(schema);
                }
                return true;
            });
        }
        schemas.sort((o1, o2) -> -Long.compare(o1.lastModified(), o2.lastModified()));
        List schemasF = schemas.size() > 25 ? schemas.subList(0, 25) : schemas;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "name", "group", "description", "schemaDefinitionUpdateTime");
        List<UxTableRow> rows = this.createRows(queryContext, schemasF);
        UxTable table = UxTable.create(null, header, rows);
        return UxReply.actionSuccess(new UxSearchSchemaDefs(table));
    }

    private List<UxTableRow> createRows(UxQueryContext context, List<OlapSchemaFactoryInfo> schemas) {
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (OlapSchemaFactoryInfo schema : schemas) {
            rows.add(UxSearchSchemaDefsQuery.createRow(context, schema));
        }
        return rows;
    }

    private static UxTableRow createRow(UxQueryContext context, OlapSchemaFactoryInfo schema) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxSchemaFactoryFile schemaFile = UxSchemaFactoryFile.fromFile(context, true, schema.getFile());
        UxSchemaId schemaId = new UxSchemaId(schema.getName(), schemaFile.relativePath());
        UxUseCase useCase = new UxUseCaseBuilder(context, UxSchemaBuilderHomeQueryMeta.BuilderHomeS, schemaId).withId(UxBuilderUseCaseName.BuilderHomeS).build(true);
        cells.add(new UxTableCell((Object)schema.getName(), useCase));
        cells.add(new UxTableCell(schema.getGroup() != null ? schema.getGroup() : ""));
        cells.add(new UxTableCell(schema.getDescription() != null ? schema.getDescription() : ""));
        long lastEditedTime = schema.lastModified();
        String lastEditedTime_ = lastEditedTime > 0L ? UxUtils.formatTimeServer(babylon, new Date(lastEditedTime)) : "";
        cells.add(new UxTableCell(lastEditedTime_).withValue_(lastEditedTime));
        return new UxTableRow(cells);
    }

    private static boolean isAccepted(String searchText, String name, @Nullable String group, @Nullable String description) {
        String searchTextU = searchText.toUpperCase();
        return name.toUpperCase().contains(searchTextU) || group != null && group.toUpperCase().contains(searchTextU) || description != null && description.toUpperCase().contains(searchTextU);
    }
}

