/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import org.jetbrains.annotations.Nullable;

public abstract class UxSchemaValidator {
    private UxSchemaValidator() {
    }

    @Nullable
    public static UxValidationResult validate(UxQueryContext queryContext, IOlapBuilderSchemaDefFactory schemaDef) {
        UxValidationResult result = UxSchemaValidator.validateSchema(queryContext, schemaDef);
        if (result != null && result.hasErrors()) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static UxValidationResult validateSchema(UxQueryContext queryContext, IOlapBuilderSchemaDefFactory schemaDef) {
        UxServerRequestContext context = queryContext.asServerRequestContext();
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(false);
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        OlapEngineComponent engine = context.getOlapEngineComponent();
        OlapProperties properties = engine.getProperties();
        OlapFunctionRepository functionRepository = engine.getFunctionRepository();
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapBuilderValidationContext validationContext = new OlapBuilderValidationContext(context.asRuntimeContext(), false, OlapEngineOfflineMode.OFF, context.isPerspectivesLicensed(), context.isTablePartitioningLicensed(), context.isFactsPartitioningLicensed(), context.isJavaMdxNativesActivated(), properties, functionRepository, schemaFunctionRepository.createSnapshot(), context.getOlapEngineComponent().getModuleMethodsRepository(), connectionPool, errorManager);
        try {
            UxSchemaValidator.doValidateSchema(validationContext, schemaDef);
            UxValidationResult uxValidationResult = null;
            return uxValidationResult;
        }
        catch (OlapContextualBigException ex) {
            UxValidationResult uxValidationResult = UxUtils.setupValidationResult(queryContext, context.getBabylonService(), errorManager.getErrors());
            return uxValidationResult;
        }
        finally {
            connectionPool.close();
        }
    }

    private static void doValidateSchema(OlapBuilderValidationContext validationContext, IOlapBuilderSchemaDefFactory schemaDef) throws OlapContextualBigException {
        OlapBuilderErrorManager errorManager = (OlapBuilderErrorManager)validationContext.getErrorManager();
        try {
            OlapBuilderSchemaMain.validate((OlapBuilderValidationContext)validationContext, (IOlapBuilderSchemaDefFactory)schemaDef);
            if (errorManager.hasErrors()) {
                throw errorManager.asException();
            }
        }
        catch (OlapBuilderErrorException ex) {
            OlapLoggers.UX_REQUEST.warn((Object)"[UX] schema validation error-exception", (Throwable)ex);
            errorManager.addError((OlapContextualError)ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }
}

