/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.schema.UxDeployAndLoadSchemaDefQueryMeta;
import crazydev.iccube.ux.builder.queries.schema.UxDeploySchemaDefQueryMeta;
import crazydev.iccube.ux.builder.queries.schema.UxValidateSchemaDefQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxHomeEntry;
import crazydev.iccube.ux.common.reply.UxHomeReplyPayload;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class UxSchemaDeploymentQuery
extends UxSchemaBuilderQuery {
    protected UxSchemaDeploymentQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        List infos = service.readSchema(this.schemaId, -1, (lock, schema) -> schema.getHierarchiesWithoutAll(lock));
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxHomeReplyPayload payload = new UxHomeReplyPayload(UxAppType.builder, null, this.setupWarnings(babylon, infos), Arrays.asList(UxHomeEntry.synopsis(babylon.translate("schemaDef_validate", new Serializable[0]), babylon.translate("schemaDef_validate.synopsis", new Serializable[0]), UxValidateSchemaDefQueryMeta.createAction(queryContext, this.schemaId)), UxHomeEntry.synopsis(babylon.translate("schemaDef_deploy", new Serializable[0]), babylon.translate("schemaDef_deploy.synopsis", new Serializable[0]), UxDeploySchemaDefQueryMeta.createAction(queryContext, this.schemaId)), UxHomeEntry.synopsis(babylon.translate("schemaDef_deployAndLoad", new Serializable[0]), babylon.translate("schemaDef_deployAndLoad.synopsis", new Serializable[0]), UxDeployAndLoadSchemaDefQueryMeta.createAction(queryContext, this.schemaId))));
        return UxReply.success(payload);
    }

    private String setupWarnings(UxBabylonService babylon, List<String> infos) {
        if (infos.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(babylon.translate("hierarchiesWithoutAll", new Serializable[0])).append("\n\n");
        for (String info : infos) {
            sb.append("  ").append(info).append("\n");
        }
        return sb.toString();
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.SchemaDeployment, this.schemaId));
    }
}

