/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaProps;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxSaveSchemaPropsQuery
extends UxSchemaBuilderQuery {
    private final UxModel model;

    public UxSaveSchemaPropsQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxModel model) {
        super(meta, requestId, schemaId);
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
        UxBuilderSchemaProps props = (UxBuilderSchemaProps)converter.convertToServerModel(queryContext, this.model);
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            props.update(schema.getDefinition(lock));
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "edit properties");
            return UxReply.actionSuccess();
        });
    }
}

