/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxDownloadSchemaDefFileQuery
extends UxSchemaBuilderQuery {
    protected UxDownloadSchemaDefFileQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        OlapSchemaFactoryInfo schema = service.getSchemaShortInfo(this.schemaId, true);
        String content = schema.getDefContent();
        UxSchemaFactoryFile schemaFile = UxSchemaFactoryFile.fromFile(queryContext, true, schema.getFile());
        String mimeType = queryContext.getMimeTypeByExtension(schemaFile.getName());
        UxFileWrapper wrapper = UxFileWrapper.forString(schemaFile.getName(), content, mimeType);
        return new UxAttachmentReply(wrapper, null);
    }
}

