/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revisions;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.revisions.UxBookmarkSchemaDefRevisionQueryMeta;
import crazydev.iccube.ux.builder.queries.revisions.UxDownloadSchemaDefRevisionQueryMeta;
import crazydev.iccube.ux.builder.queries.revisions.UxRestoreSchemaDefRevisionQueryMeta;
import crazydev.iccube.ux.builder.queries.revisions.UxSchemaDefRevisionQuery;
import crazydev.iccube.ux.builder.queries.revisions.UxSchemaDefRevisionsQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;

public class UxSchemaDefRevisionQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxSchemaDefRevisionQueryMeta SchemaDefRevision = new UxSchemaDefRevisionQueryMeta();

    protected UxSchemaDefRevisionQueryMeta() {
        super(UxConsoleConstants.QueryName.SchemaDefRevision);
    }

    @Override
    public String[] getGroup() {
        return new String[]{"revisions"};
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        String revFileName = params.getExistingStringParameter("revFileName");
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxSchemaDefRevisionQuery(this, params.getRequestId(), schemaId, revFileName, tableOptions);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, String revFileName) {
        return this.createQueryUrl(schemaId).addParam("revFileName", String.valueOf(revFileName));
    }

    static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, String revFileName) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = SchemaDefRevision.createActions(context, schemaId);
        actions.add(UxRestoreSchemaDefRevisionQueryMeta.createAction(context, schemaId, revFileName));
        actions.add(UxBookmarkSchemaDefRevisionQueryMeta.createAction(context, schemaId, revFileName));
        actions.add(UxDownloadSchemaDefRevisionQueryMeta.createAction(context, schemaId, revFileName));
        return new UxUseCaseBuilder(context, SchemaDefRevision, schemaId).withId(UxBuilderUseCaseName.SchemaDefRevision.name() + "-" + revFileName).withCaption(babylon.translateUseCaseCaption(UxBuilderUseCaseName.SchemaDefRevision.name(), new Serializable[0])).withUrl(SchemaDefRevision.createQueryUrl(schemaId, revFileName)).withExtraTitle(new UxUseCaseTitle(UxSchemaDefRevisionsQueryMeta.createUseCase(context, schemaId, false), revFileName, UxBuilderUseCaseRepository.asBookmark(SchemaDefRevision.createQueryUrl(schemaId, revFileName)))).withActions(actions).build(true);
    }
}

