/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revisions;

import crazydev.common.fs.revision.CdVFileRev;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxDownloadSchemaDefRevisionQuery
extends UxSchemaBuilderQuery {
    private final String revFileName;

    protected UxDownloadSchemaDefRevisionQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String revFileName) {
        super(meta, requestId, schemaId);
        this.revFileName = revFileName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            CdVFileRev revision = service.getSchemaDefRevision(lock, schema, this.revFileName, true);
            String content = revision.getPayload();
            if (content == null) {
                content = "";
            }
            String schemaFileName = revision.getMainFileName();
            String mimeType = queryContext.getMimeTypeByExtension(schemaFileName);
            UxFileWrapper wrapper = UxFileWrapper.forString(schemaFileName, content, mimeType);
            return new UxAttachmentReply(wrapper, null);
        });
    }
}

