/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.perspective;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.perspective.UxPerspectiveQueryMeta;
import crazydev.iccube.ux.builder.queries.perspective.UxSavePerspectiveQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxPerspectiveQuery
extends UxSchemaBuilderQuery {
    private final String name;

    public UxPerspectiveQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderPerspectiveDef perspective = schema.getPerspective(lock, this.name);
            if (perspective == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"perspective", this.name}));
            }
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, 1, lock, (Object)schema, perspective, (Boolean)true);
            UxAction save = UxSavePerspectiveQueryMeta.createAction(queryContext, this.schemaId, perspective.getName());
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxPerspectiveQueryMeta.createUseCase(queryContext, this.schemaId, this.name));
    }
}

