/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.measures;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.queries.measures.UxMeasureQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveMeasureQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderMeasureUniqueName measureName;
    private final UxModel model;

    public UxSaveMeasureQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderMeasureUniqueName measureName, UxModel model) {
        super(meta, requestId, schemaId);
        this.measureName = measureName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderMeasureDef measure = (IOlapBuilderMeasureDef)converter.convertToServerModel(queryContext, this.model);
            if (!measure.getUUID().equals(this.measureName.asUUID())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_UUID_MISMATCH, (Serializable[])new Serializable[]{this.measureName.asUUID(), measure.getUUID()}));
            }
            if (!this.measureName.getMeasureName().equals(measure.getName())) {
                UxBuilderMeasureReference existingMeasure = schema.renameMeasure(lock, this.measureName, measure.getName());
                converter.update(existingMeasure.measure, measure);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxMeasureQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderMeasureUniqueName.create(existingMeasure.cube, existingMeasure.measureGroup, existingMeasure.measure)));
                operation = "rename/edit measure: " + this.measureName.asString() + " into: " + measure.getName();
            } else {
                UxBuilderMeasureReference existingMeasure = schema.getExistingMeasure(lock, this.measureName);
                converter.update(existingMeasure.measure, measure);
                continuation = null;
                operation = "edit measure: " + this.measureName.asString();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

