/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.measures;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.model.UxExtraNavigationKeyId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNodeId;
import crazydev.iccube.ux.builder.queries.measures.UxCreateMeasureQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxDeleteMeasureQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxMeasureQuery;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxMeasureQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxMeasureQueryMeta Measure = new UxMeasureQueryMeta();

    protected UxMeasureQueryMeta() {
        super(UxConsoleConstants.QueryName.Measure);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return UxUrlConstants.HELP_SCHEMA_FACTS_AGGREGATION;
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderMeasureUniqueName name = params.getExistingMeasureNameParameter("name");
        return new UxMeasureQuery(this, params.getRequestId(), schemaId, name);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, UxBuilderMeasureUniqueName name) {
        return this.createQueryUrl(schemaId).addParam("name", name.asUrlParam());
    }

    @Nullable
    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, @Nullable UxBuilderMeasureUniqueName prevName, UxBuilderMeasureUniqueName name) {
        return UxMeasureQueryMeta.createUseCase(context, UxActionSetup.ALL, schemaId, prevName, name);
    }

    @Nullable
    public static UxUseCase createUseCase(UxQueryContext context, UxActionSetup actionSetup, UxSchemaId schemaId, @Nullable UxBuilderMeasureUniqueName prevName, UxBuilderMeasureUniqueName name) {
        List<UxAction> actions = null;
        if (actionSetup == UxActionSetup.ALL) {
            actions = Measure.createActions(context, schemaId);
            UxBuilderMeasureGroupUniqueName measureGroupUniqueName = name.getMeasureGroupUniqueName();
            if (measureGroupUniqueName != null) {
                actions.add(UxCreateMeasureQueryMeta.createAction(context, schemaId, measureGroupUniqueName, 2));
            }
            actions.add(UxDeleteMeasureQueryMeta.createAction(context, schemaId, name));
        } else if (actionSetup == UxActionSetup.NAVIGATION_TREE) {
            actions = new ArrayList<UxAction>();
            actions.add(UxDeleteMeasureQueryMeta.createAction(context, schemaId, name));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = Measure.createQueryUrl(schemaId, name);
        UxUseCaseBuilder builder = new UxUseCaseBuilder(context, Measure, schemaId).withId(UxBuilderUseCaseName.Measure, name.getMeasureName()).withExtraNavigationKeyId(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(name))).withCaption(babylon.translate("measureUC", new Serializable[]{name.getMeasureName()})).withParentId(UxBuilderUseCaseName.Measures).withUrl(url).withActions(actions);
        if (prevName != null) {
            builder = builder.withExtraNavigationKeyId_(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(prevName)));
        }
        return builder.build(actionSetup != UxActionSetup.NONE);
    }
}

