/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.measures;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.queries.measures.UxMeasureQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxSaveMeasureQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxMeasureQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderMeasureUniqueName name;
    private UxBuilderMeasureReference measure;

    public UxMeasureQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderMeasureUniqueName name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.measure = schema.getExistingMeasure(lock, this.name);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, 1, lock, (Object)this.measure.measureGroup, this.measure.measure, (Boolean)true);
            UxAction save = UxSaveMeasureQueryMeta.createAction(queryContext, this.schemaId, this.name);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.measure != null) {
            reply.withUseCase(UxMeasureQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderMeasureUniqueName.create(this.measure.cube, this.measure.measureGroup, this.measure.measure)));
        }
    }
}

