/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.localization;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCalcMemberDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptExecutionInfo;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.calcmember.OlapCreateCalcMemberStatementInstr;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashSet;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jetbrains.annotations.Nullable;

public class UxSchemaLocalizationHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateXlsFile(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable OlapSchema loadedSchema, OlapSchemaLocalization localization, boolean withMembers) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        try {
            HSSFWorkbook wb = UxSchemaLocalizationHelper.generateXlsWorkBook(context, lock, schema, loadedSchema, localization, withMembers);
            out = new ByteArrayOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return byArray;
    }

    private static HSSFWorkbook generateXlsWorkBook(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable OlapSchema loadedSchema, OlapSchemaLocalization localization, boolean withMembers) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        int rowIdx = 0;
        ArrayList locales = new ArrayList(localization.getLocaleNames());
        locales.sort(String::compareToIgnoreCase);
        HSSFRow header = sheet.createRow(rowIdx++);
        HSSFCell cell = header.createCell(0);
        cell.setCellValue("UNIQUE_NANE");
        cell = header.createCell(1);
        cell.setCellValue("NAME");
        int col = 2;
        for (String locale : locales) {
            HSSFCell cell2 = header.createCell(col++);
            cell2.setCellValue(locale);
        }
        HashSet tags = new HashSet();
        for (String locale : locales) {
            tags.addAll(localization.getTags(locale));
        }
        SchemaEntityList schemaEntities = UxSchemaLocalizationHelper.generateRows(context, lock, schema, loadedSchema, withMembers);
        for (SchemaEntity schemaEntity : schemaEntities) {
            String uniqueName = schemaEntity.uniqueName();
            HSSFRow sheetRow = sheet.createRow(rowIdx++);
            HSSFCell cell3 = sheetRow.createCell(0);
            cell3.setCellValue(uniqueName);
            cell3 = sheetRow.createCell(1);
            cell3.setCellValue(schemaEntity.name());
            int col2 = 2;
            for (String locale : locales) {
                String value = localization.getValue(locale, uniqueName);
                HSSFCell cell4 = sheetRow.createCell(col2++);
                cell4.setCellValue(value != null ? value : "");
            }
            tags.remove(uniqueName);
        }
        for (String tag : tags) {
            HSSFRow sheetRow = sheet.createRow(rowIdx++);
            HSSFCell cell5 = sheetRow.createCell(0);
            cell5.setCellValue(tag);
            int col3 = 2;
            for (String locale : locales) {
                String value = localization.getValue(locale, tag);
                HSSFCell cell6 = sheetRow.createCell(col3++);
                cell6.setCellValue(value != null ? value : "");
            }
        }
        return wb;
    }

    private static SchemaEntityList generateRows(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, @Nullable OlapSchema loadedSchema, boolean withMembers) {
        SchemaEntityList rows = new SchemaEntityList();
        UxSchemaLocalizationHelper.generateHierarchyRows(rows, lock, schema);
        UxSchemaLocalizationHelper.generateLevelRows(rows, lock, schema);
        UxSchemaLocalizationHelper.generateCubeRows(rows, lock, schema);
        UxSchemaLocalizationHelper.generateCubeFacts(rows, lock, schema);
        UxSchemaLocalizationHelper.generateScriptCalcMembers(rows, context, lock, schema);
        rows.addSchemaEntity("[Measures]", "Measures");
        if (withMembers && loadedSchema != null) {
            UxSchemaLocalizationHelper.generateMembersRows(rows, context, loadedSchema);
        }
        return rows;
    }

    private static void generateHierarchyRows(SchemaEntityList rows, UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        try {
            schema.forEachDimension(lock, dimension -> {
                String dimensionUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension);
                if (!CdStringUtils.isNullOrBlank((String)dimensionUniqueName)) {
                    rows.addSchemaEntity(dimensionUniqueName, dimension.getName());
                }
                List hierarchies = dimension.getHierarchies();
                for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
                    String allMemberNameUniqueName;
                    String allMemberName;
                    String allLevelNameUniqueName;
                    String uniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy);
                    if (!CdStringUtils.isNullOrBlank((String)uniqueName)) {
                        rows.addSchemaEntity(uniqueName, hierarchy.getName());
                    }
                    if (!hierarchy.hasAll()) continue;
                    String allLevelName = hierarchy.getAllLevelName();
                    if (!CdStringUtils.isNullOrBlank((String)allLevelName) && !CdStringUtils.isNullOrBlank((String)(allLevelNameUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy, allLevelName)))) {
                        rows.addSchemaEntity(allLevelNameUniqueName, allLevelName);
                    }
                    if (CdStringUtils.isNullOrBlank((String)(allMemberName = hierarchy.getAllMemberName())) || CdStringUtils.isNullOrBlank((String)(allMemberNameUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy, allMemberName)))) continue;
                    rows.addSchemaEntity(allMemberNameUniqueName, allMemberName);
                }
            });
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[localization] could not generate hierarchy template", (Throwable)ex);
        }
    }

    private static void generateLevelRows(SchemaEntityList rows, UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        try {
            schema.forEachDimension(lock, dimension -> {
                List hierarchies = dimension.getHierarchies();
                for (IOlapBuilderHierarchyDef hierarchy : hierarchies) {
                    List levels = hierarchy.getLevels();
                    for (IOlapBuilderHierarchyLevelDef level : levels) {
                        String allMemberNameUniqueName;
                        String allMemberName;
                        String allLevelNameUniqueName;
                        String uniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy, level);
                        if (!CdStringUtils.isNullOrBlank((String)uniqueName)) {
                            rows.addSchemaEntity(uniqueName, level.getName());
                        }
                        if (!hierarchy.hasAll()) continue;
                        String allLevelName = hierarchy.getAllLevelName();
                        if (!CdStringUtils.isNullOrBlank((String)allLevelName) && !CdStringUtils.isNullOrBlank((String)(allLevelNameUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy, allLevelName)))) {
                            rows.addSchemaEntity(allLevelNameUniqueName, allLevelName);
                        }
                        if (CdStringUtils.isNullOrBlank((String)(allMemberName = hierarchy.getAllMemberName())) || CdStringUtils.isNullOrBlank((String)(allMemberNameUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy, allMemberName)))) continue;
                        rows.addSchemaEntity(allMemberNameUniqueName, allMemberName);
                    }
                }
            });
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[localization] could not generate level template", (Throwable)ex);
        }
    }

    private static void generateCubeRows(SchemaEntityList rows, UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        try {
            schema.forEachCubes(lock, cube -> {
                String uniqueName = UxSchemaLocalizationHelper.generateUniqueName(cube);
                if (!CdStringUtils.isNullOrBlank((String)uniqueName)) {
                    rows.addSchemaEntity(uniqueName, cube.getName());
                }
            });
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[localization] could not generate cube template", (Throwable)ex);
        }
    }

    private static void generateCubeFacts(SchemaEntityList rows, UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        try {
            schema.forEachMeasureGroups(lock, facts -> {
                List calcMeasures;
                List measures;
                IOlapBuilderCubeDef cube = facts.cube;
                IOlapBuilderBaseFactsDef measureGroup = facts.measureGroup;
                String uniqueName = UxSchemaLocalizationHelper.generateUniqueName(cube, measureGroup);
                if (!CdStringUtils.isNullOrBlank((String)uniqueName)) {
                    rows.addSchemaEntity(uniqueName, measureGroup.getName());
                }
                if ((measures = measureGroup.getDefinedMeasures()) != null) {
                    for (IOlapBuilderMeasureDef measure : measures) {
                        String un = UxSchemaLocalizationHelper.generateUniqueName(cube, measure);
                        if (CdStringUtils.isNullOrBlank((String)un)) continue;
                        UxSchemaLocalizationHelper.addRowWithDisplayFolder(rows, un, measure.getName());
                    }
                }
                if ((calcMeasures = cube.getCalcMeasures()) != null) {
                    for (IOlapBuilderCalcMemberDef measure : calcMeasures) {
                        String un = UxSchemaLocalizationHelper.generateUniqueName(measure);
                        if (CdStringUtils.isNullOrBlank((String)un)) continue;
                        UxSchemaLocalizationHelper.addRowWithDisplayFolder(rows, un, measure.getName());
                    }
                }
            });
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[localization] could not generate facts template", (Throwable)ex);
        }
    }

    private static void addRowWithDisplayFolder(SchemaEntityList rows, String un, String n) {
        rows.addSchemaEntity(un, n);
        rows.addSchemaEntity(un + ".[DISPLAY_FOLDER]", null);
    }

    private static void generateScriptCalcMembers(SchemaEntityList rows, UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        try {
            CdCaseInsensitiveHashSet dimensions = new CdCaseInsensitiveHashSet(schema.getDimensionNames(lock));
            CdCaseInsensitiveHashSet cubes = new CdCaseInsensitiveHashSet(schema.getCubeNames(lock));
            String cube0 = schema.getFirstCubeName(lock);
            OlapBuilderScript script = schema.getScript(lock);
            String scriptName = schema.getName() + "." + script.getName();
            String mdx = script.getContent();
            OlapEngineRequestContext requestContext = context.getOlapEngineRequestContext();
            OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create((OlapEngineRequestContext)requestContext);
            OlapEngineMdxScriptCompilationInfo compilationInfo = mdxHelper.compileMdxScript(schema.getName(), scriptName, mdx, scriptName);
            if (compilationInfo.getResult() == null && compilationInfo.getScriptInstr() != null) {
                OlapEngineMdxScriptExecutionInfo executionInfo = compilationInfo.asExecutionInfo();
                OlapEngineMdxScriptExecutionInfo phaseI = executionInfo.asBuilderPhaseI();
                OlapScriptInstr instr = phaseI.getScriptInstr();
                List statements = instr.getStatements();
                for (OlapStatementInstr statement : statements) {
                    if (!(statement instanceof OlapCreateCalcMemberStatementInstr)) continue;
                    OlapCreateCalcMemberStatementInstr calc = (OlapCreateCalcMemberStatementInstr)statement;
                    UxSchemaLocalizationHelper.generateScriptCalcMember(rows, (Set<String>)dimensions, (Set<String>)cubes, cube0, calc);
                }
            }
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[localization] could not generate calc. measures template", (Throwable)ex);
        }
    }

    private static void generateScriptCalcMember(SchemaEntityList rows, Set<String> dimensions, Set<String> cubes, String cube0, OlapCreateCalcMemberStatementInstr statement) {
        OlapEntityIdentifier id = statement.getId();
        if (id.isAll() || id.isKey()) {
            return;
        }
        String firstPart = id.getFirstPartAsName();
        if (dimensions.contains(firstPart)) {
            String row = id.asMdxString();
            if (row != null) {
                rows.addSchemaEntity(row, id.getLastPartAsName());
            }
            return;
        }
        if (id.getPartCount() == 1) {
            if (cube0 != null) {
                UxSchemaLocalizationHelper.addRowWithDisplayFolder(rows, "[" + CdMdxUtils.escape((String)cube0) + "].[Measures].[" + CdMdxUtils.escape((String)id.getLastPartAsName()) + "]", id.getLastPartAsName());
            }
            return;
        }
        if (id.getPartCount() == 2) {
            if ("measures".equalsIgnoreCase(firstPart)) {
                if (cube0 != null) {
                    UxSchemaLocalizationHelper.addRowWithDisplayFolder(rows, "[" + CdMdxUtils.escape((String)cube0) + "].[Measures].[" + CdMdxUtils.escape((String)id.getLastPartAsName()) + "]", id.getLastPartAsName());
                }
            } else if (cubes.contains(firstPart)) {
                UxSchemaLocalizationHelper.addRowWithDisplayFolder(rows, "[" + CdMdxUtils.escape((String)firstPart) + "].[Measures].[" + CdMdxUtils.escape((String)id.getLastPartAsName()) + "]", id.getLastPartAsName());
            }
            return;
        }
        if (id.getPartCount() == 3) {
            String row = id.asMdxString();
            if (row != null) {
                UxSchemaLocalizationHelper.addRowWithDisplayFolder(rows, row, id.getLastPartAsName());
            }
            return;
        }
    }

    private static void generateMembersRows(SchemaEntityList rows, UxQueryContext context, OlapSchema schema) {
        try {
            List dimensions = schema.getDimensions();
            for (OlapDimension dimension : dimensions) {
                if (dimension.isMeasures()) continue;
                List hierarchies = dimension.getHierarchies();
                block3: for (OlapHierarchy hierarchy : hierarchies) {
                    OlapMember member;
                    int counter = 0;
                    OlapTupleSet hMembers = hierarchy.getMembers();
                    OlapIterator members = hMembers.getIterator(false);
                    members.reset();
                    while ((member = (OlapMember)members.next()) != null) {
                        if (member.isAll()) continue;
                        if (counter++ % 100 == 0 && context.isCancelling()) continue block3;
                        String uniqueName = member.getUniqueName(OlapNameContext.DEFAULT_VALUES);
                        if (CdStringUtils.isNullOrBlank((String)uniqueName)) continue;
                        rows.addSchemaEntity(uniqueName, member.getNameX());
                    }
                }
            }
        }
        catch (Exception ex) {
            OlapLoggers.BUILDER.warn((Object)"[localization] could not generate members template", (Throwable)ex);
        }
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderCubeDef cube) {
        String name = cube.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        return "[" + CdMdxUtils.escape((String)name) + "]";
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef facts) {
        String name = facts.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        String cubeUN = UxSchemaLocalizationHelper.generateUniqueName(cube);
        return (String)(cubeUN != null ? cubeUN + "." : "") + "[" + CdMdxUtils.escape((String)name) + "]";
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderCubeDef cube, IOlapBuilderMeasureDef measure) {
        String name = measure.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        String cubeUN = UxSchemaLocalizationHelper.generateUniqueName(cube);
        return (String)(cubeUN != null ? cubeUN + "." : "") + "[Measures].[" + CdMdxUtils.escape((String)name) + "]";
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderCalcMemberDef measure) {
        String name = measure.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        return name;
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderDimensionDef dimension) {
        String name = dimension.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        return "[" + CdMdxUtils.escape((String)name) + "]";
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        String name = hierarchy.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        String dimensionUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension);
        if (CdStringUtils.isNullOrBlank((String)dimensionUniqueName)) {
            return null;
        }
        return dimensionUniqueName + ".[" + CdMdxUtils.escape((String)name) + "]";
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy, IOlapBuilderHierarchyLevelDef level) {
        String name = level.getName();
        if (CdStringUtils.isNullOrBlank((String)name)) {
            return null;
        }
        String hierarchyUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy);
        if (CdStringUtils.isNullOrBlank((String)hierarchyUniqueName)) {
            return null;
        }
        return hierarchyUniqueName + ".[" + CdMdxUtils.escape((String)name) + "]";
    }

    @Nullable
    private static String generateUniqueName(IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy, String all) {
        if (CdStringUtils.isNullOrBlank((String)all)) {
            return null;
        }
        String hierarchyUniqueName = UxSchemaLocalizationHelper.generateUniqueName(dimension, hierarchy);
        if (CdStringUtils.isNullOrBlank((String)hierarchyUniqueName)) {
            return null;
        }
        return hierarchyUniqueName + ".[" + CdMdxUtils.escape((String)all) + "]";
    }

    private static class SchemaEntityList
    extends ArrayList<SchemaEntity> {
        private SchemaEntityList() {
        }

        public void addSchemaEntity(String uniqueName, @Nullable String name) {
            this.add(new SchemaEntity(uniqueName, name));
        }
    }

    private record SchemaEntity(String uniqueName, @Nullable String name) {
    }
}

