/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.localization;

import crazydev.common.collection.CdSetList;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.localization.OlapBuilderLocalizationBuilder;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapDefaultSchemaLocalization;
import crazydev.iccube.olap.schema.localization.OlapEmptySchemaLocalization;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.localization.UxSchemaLocalizationHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDownloadSchemaLocalizationQuery
extends UxSchemaBuilderQuery {
    private final boolean withMembers;

    public UxDownloadSchemaLocalizationQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, boolean withMembers) {
        super(meta, requestId, schemaId);
        this.withMembers = withMembers;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        if (!this.withMembers) {
            return null;
        }
        return this.schemaId.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        if (!this.withMembers) {
            return IcCubeSchemaAccessLockMode.NONE;
        }
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchemaClone(this.schemaId, -1, (lock, schema) -> {
            byte[] content = null;
            try {
                OlapSchemaLocalization localization = this.setupLocalization(queryContext, lock, schema);
                OlapSchema loadedSchema = null;
                if (this.withMembers && this.schemaId.schemaName != null) {
                    OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
                    OlapEngineComponent olapEngine = engineRequestContext.getOlapEngineComponent();
                    loadedSchema = olapEngine.getAuthorizedSchema(engineRequestContext, IcCubeSchemaAccessLockMode.READ, this.schemaId.schemaName);
                }
                content = UxSchemaLocalizationHelper.generateXlsFile(queryContext, lock, schema, loadedSchema, localization, this.withMembers);
            }
            catch (IOException ex) {
                OlapLoggers.BUILDER.warn((Object)"[localization] Could not generate schema template", (Throwable)ex);
                content = new byte[]{};
            }
            String filename = schema.getName() + ".xls";
            String mimeType = "application/vnd.ms-excel";
            UxFileWrapper wrapper = UxFileWrapper.forBinary(filename, content, "application/vnd.ms-excel");
            return new UxAttachmentReply(wrapper, null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLocalization setupLocalization(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema) {
        IOlapBuilderLocalizationDef localizationDef = schema.getLocalization(lock);
        if (localizationDef == null) {
            return new OlapEmptySchemaLocalization();
        }
        try (OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();){
            OlapSchemaLocalization olapSchemaLocalization = this.setupLocalization(context, connectionPool, lock, schema, localizationDef);
            return olapSchemaLocalization;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapSchemaLocalization setupLocalization(UxQueryContext qContext, OlapBuilderConnectionPool connectionPool, UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderLocalizationDef localizationDef) {
        String id;
        OlapBuilderSchema schemaDef = schema.getDefinition(lock);
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
        OlapBuilderReferenceSolver solver = OlapBuilderSchemaMain.createReferenceSolver((OlapBuilderErrorManager)errorManager, (IOlapBuilderSchemaDef)schemaDef);
        IOlapBuilderTabularDataDef localizationDefTabularData = localizationDef.isEnabled() ? ((id = localizationDef.getDataTableId()) != null ? solver.getTabularData(id) : null) : null;
        if (localizationDefTabularData instanceof OlapBuilderBaseDataView) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI((boolean)true, (IOlapBuilderSchemaDef)schemaDef, (IOlapBuilderDataViewDef)((IOlapBuilderDataViewDef)localizationDefTabularData));
        }
        OlapDefaultSchemaLocalization localization = new OlapDefaultSchemaLocalization(schemaDef.getSchemaLocalizationFallbackLocale());
        OlapBuilderLocalizationBuilder builder = new OlapBuilderLocalizationBuilder((OlapSchemaLocalization)localization);
        localizationDefTabularData.addListener((IOlapBuilderTableListener)builder);
        OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
        CdSetList tables = localizationDefTabularData.getUnderlyingTables();
        OlapEngineRequestContext eContext = qContext.getOlapEngineRequestContext();
        eContext.setupBuilderLoadExecutors(false);
        try {
            OlapEngineLoadSchemaParams params = new OlapEngineLoadSchemaParams(null, false, -1, -1, OlapEngineOfflineMode.OFF, null, false);
            OlapBuilderContext bContext = new OlapBuilderContext(eContext, (IOlapEngineLoadSchemaParams)params, OlapBuilderContextMode.FULL_LOAD, null, null);
            OlapBuilderTableProcessingHelper.processTables((OlapBuilderContext)bContext, (OlapBuilderConnectionPool)connectionPool, (OlapThreadPoolExecutorTaskSchedulingPolicy)processingSchedulingPolicy, (List)tables);
            OlapDefaultSchemaLocalization olapDefaultSchemaLocalization = localization;
            return olapDefaultSchemaLocalization;
        }
        finally {
            eContext.releaseBuilderLoadExecutors(true);
        }
    }
}

