/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.level;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyReference;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.queries.level.UxLevelQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.io.Serializable;

public class UxSaveLevelExQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderHierarchyUniqueName hierarchyName;
    private final UxModel model;

    public UxSaveLevelExQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderHierarchyUniqueName hierarchyName, UxModel model) {
        super(meta, requestId, schemaId);
        this.hierarchyName = hierarchyName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderBaseHierarchyLevelDef level = (IOlapBuilderBaseHierarchyLevelDef)converter.convertToServerModel(queryContext, this.model);
            UxBuilderHierarchyReference existingHierarchy = schema.getExistingHierarchy(lock, this.hierarchyName);
            if (existingHierarchy.hierarchy.getLevelForUX(level.getName()) != null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.LEVEL_NAME_DUPLICATED, new Serializable[]{level.getName()});
            }
            existingHierarchy.hierarchy.addLevelForUX(level);
            UxBuilderLevelUniqueName levelName = UxBuilderLevelUniqueName.create(existingHierarchy.dimension, existingHierarchy.hierarchy, level);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add level: " + levelName.asString());
            UxUseCase levelUC = UxLevelQueryMeta.createUseCase(queryContext, UxActionSetup.NONE, this.schemaId, levelName);
            return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, levelUC));
        });
    }
}

