/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.image;

import crazydev.common.utils.CdResourceUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxContentReply;
import crazydev.iccube.ux.common.reply.UxNotFoundReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class UxImageQuery
extends UxAdminQuery {
    private final String clazz;
    private final String resource;

    protected UxImageQuery(UxQueryMeta meta, OlapRequestId requestId, String clazz, String resource) {
        super(meta, requestId);
        this.clazz = clazz;
        this.resource = resource;
    }

    @Override
    public boolean ignoreCSRFToken() {
        return true;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        try {
            String contentType = queryContext.getMimeTypeByExtension(this.resource);
            byte[] content = UxImageQuery.getImage(queryContext, this.clazz, this.resource);
            return new UxContentReply(contentType, content, new Header[]{new BasicHeader("Cache-Control", "public, max-age=31536000")});
        }
        catch (Exception ex) {
            return new UxNotFoundReply(this.resource);
        }
    }

    public static byte[] getImage(UxQueryContext context, String className, String resource) throws Exception {
        Class<?> clazz = UxImageQuery.getClazz(context, className);
        InputStream in = CdResourceUtils.getResourceAsStream(clazz, (String)resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        return out.toByteArray();
    }

    private static Class<?> getClazz(UxQueryContext context, String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            OlapEngineComponent engine = context.getOlapEngineComponent();
            OlapBuilderMetaInformationRepository repository = engine.getBuilderMetaInformationRepository();
            Class clazz = repository.getDataSourceClass(className);
            if (clazz == null) {
                throw new ClassNotFoundException(className);
            }
            return clazz;
        }
    }
}

