/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardUuidProp;
import crazydev.iccube.builder.ux.meta.hierarchy.wizard.UxBuilderCreateHierarchyWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveHierarchyWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;

    public UxSaveHierarchyWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        int revNumber = -1;
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderCreateHierarchyWizard wizard = UxWizardDef.setupCreateHierarchyWizardFromJson(queryContext, lock, schema, this.props, -1, this.stepDefs, this.stepModels);
            UxBuilderWizardUuidProp dimensionName = wizard.getDimensionName();
            if (dimensionName == null) {
                throw new UxQueryExpectedException(UxErrorCode.BUILDER_HIERARCHY_WIZARD_ERROR, new Serializable[]{"missing props.dimensionName"});
            }
            IOlapBuilderDimensionDef existingDimension = schema.getExistingDimension(lock, UxBuilderDimensionUniqueName.create(dimensionName));
            IOlapBuilderHierarchyDef hierarchy = wizard.getHierarchyFromUI();
            existingDimension.addHierarchyForUX(hierarchy);
            UxBuilderHierarchyUniqueName hierarchyName = UxBuilderHierarchyUniqueName.create(existingDimension, hierarchy);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add hierarchy: " + hierarchyName.asString());
            UxUseCase hierarchyUC = UxHierarchyQueryMeta.createUseCase(queryContext, this.schemaId, null, hierarchyName, hierarchy.withCreateLevel());
            return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, hierarchyUC));
        });
    }
}

