/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyReference;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveHierarchyQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderHierarchyUniqueName hierarchyName;
    private final UxModel model;

    public UxSaveHierarchyQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderHierarchyUniqueName hierarchyName, UxModel model) {
        super(meta, requestId, schemaId);
        this.hierarchyName = hierarchyName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)converter.convertToServerModel(queryContext, this.model);
            if (!hierarchy.getUUID().equals(this.hierarchyName.asUUID())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_UUID_MISMATCH, (Serializable[])new Serializable[]{this.hierarchyName.asUUID(), hierarchy.getUUID()}));
            }
            if (!this.hierarchyName.getHierarchyName().equals(hierarchy.getName())) {
                UxBuilderHierarchyReference existingHierarchy = schema.renameHierarchy(lock, this.hierarchyName, hierarchy.getName());
                converter.update(existingHierarchy.hierarchy, hierarchy);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxHierarchyQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderHierarchyUniqueName.create(existingHierarchy.dimension, existingHierarchy.hierarchy), hierarchy.withCreateLevel()));
                operation = "rename/edit hierarchy: " + this.hierarchyName.asString() + " into: " + hierarchy.getName();
            } else {
                UxBuilderHierarchyReference existingHierarchy = schema.getExistingHierarchy(lock, this.hierarchyName);
                converter.update(existingHierarchy.hierarchy, hierarchy);
                continuation = null;
                operation = "edit hierarchy: " + this.hierarchyName.asString();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

