/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxDeleteHierarchyQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderHierarchyUniqueName hierarchyName;

    public UxDeleteHierarchyQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderHierarchyUniqueName hierarchyName) {
        super(meta, requestId, schemaId);
        this.hierarchyName = hierarchyName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            schema.deleteHierarchy(lock, this.hierarchyName);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "delete hierarchy: " + this.hierarchyName.asString());
            return UxReply.actionSuccess();
        });
    }
}

