/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.hierarchy;

import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderBaseWithAllHierarchy;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.hierarchy.wizard.UxBuilderCreateHierarchyWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.queries.hierarchy.UxCreateHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxSaveHierarchyExQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxSaveHierarchyWizardQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxValidateCreateHierarchyWizardQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefReplyPayload;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDefStep;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardLastStep;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;

public class UxCreateHierarchyQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderDimensionUniqueName dimensionName;

    public UxCreateHierarchyQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderDimensionUniqueName dimensionName) {
        super(meta, requestId, schemaId);
        this.dimensionName = dimensionName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDimensionDef dimension = schema.getExistingDimension(lock, this.dimensionName);
            UxBuilderCreateHierarchyWizard wizard = UxBuilderCreateHierarchyWizard.create((IOlapBuilderDimensionDef)dimension);
            if (wizard != null) {
                UxWizardDef wizardDef = this.setupWizardDef(queryContext, wizard);
                return UxReply.success(new UxWizardDefReplyPayload(wizardDef));
            }
            IOlapBuilderHierarchyDef hierarchy = dimension.createEmptyHierarchy();
            if (hierarchy instanceof OlapBuilderBaseWithAllHierarchy) {
                OlapBuilderBaseWithAllHierarchy hier = (OlapBuilderBaseWithAllHierarchy)hierarchy;
                hier.setHasAllLevel(true);
            }
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            if (hierarchy.isParentChild()) {
                queryContext.setupDimensionTableUUID(dimension.getDataTableId());
            }
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, dimension, hierarchy, false);
            UxAction save = UxSaveHierarchyExQueryMeta.createAction(queryContext, this.schemaId, this.dimensionName);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    private UxWizardDef setupWizardDef(UxQueryContext context, UxBuilderCreateHierarchyWizard wizard) {
        UxBabylonService babylon = context.getUxBabylonService();
        String useCaseTitle = babylon.translateUseCaseCaption(UxBuilderUseCaseName.CreateHierarchy.name(), new Serializable[0]);
        ArrayList<UxWizardDefStep> stepsUI = new ArrayList<UxWizardDefStep>();
        for (UxBuilderWizardStep step : wizard.getSteps()) {
            stepsUI.add(this.setupWizardStepUI(context, step));
        }
        String captionAllDoneC = babylon.translate("wizard.createHierarchy.allDoneC", new Serializable[0]);
        String captionAllDoneI = babylon.translate("wizard.createHierarchy.allDoneI", new Serializable[0]);
        UxAction create = UxSaveHierarchyWizardQueryMeta.createAction(context, this.schemaId);
        UxWizardLastStep lastStep = new UxWizardLastStep(captionAllDoneC, captionAllDoneI, create);
        UxAction validate = UxValidateCreateHierarchyWizardQueryMeta.createAction(context, this.schemaId);
        return new UxWizardDef(useCaseTitle, wizard.getProps(), stepsUI, lastStep, validate);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxCreateHierarchyQueryMeta.createUseCase(queryContext, this.schemaId, this.dimensionName));
    }
}

