/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.fs;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoName;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserNodeType;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserTree;
import crazydev.iccube.ux.builder.queries.fs.UxFileChooserTreeNode;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxFileChooserQuery
extends UxBuilderQuery {
    private static final int MAX_COUNT = 4096;
    private final UxFileChooserNodeType nodeType;
    @Nullable
    private final String treeId;
    @Nullable
    private final String nodeId;

    public UxFileChooserQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String nodeType, @Nullable String treeId, @Nullable String nodeId) {
        super(meta, requestId);
        this.nodeType = UxFileChooserNodeType.Folder.name().equals(nodeType) ? UxFileChooserNodeType.Folder : UxFileChooserNodeType.File;
        this.treeId = treeId;
        this.nodeId = nodeId;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if ("ic3-dashboards".equals(this.treeId)) {
            return this.executeForDashboards(queryContext);
        }
        if (!"ic3-file-system".equals(this.treeId)) {
            return UxReply.actionSuccess(new UxFileChooserTree(this.treeId, this.nodeId, null));
        }
        OlapFileSystem fs = queryContext.getRootFileSystem();
        ArrayList<UxFileChooserTreeNode> nodes = new ArrayList<UxFileChooserTreeNode>();
        try {
            if (CdStringUtils.isNullOrBlank((String)this.nodeId)) {
                this.browseRootNodes(queryContext, fs, nodes);
            } else {
                this.browseNodes(queryContext, fs, this.nodeId, nodes);
            }
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"file system browsing IO error", (Throwable)ex);
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"IO error", ex.getMessage()}));
        }
        return UxReply.actionSuccess(new UxFileChooserTree(this.treeId, this.nodeId, nodes));
    }

    private void browseRootNodes(UxQueryContext context, OlapFileSystem fs, List<UxFileChooserTreeNode> nodes) throws IOException {
        OlapFile root;
        List roots = fs.sortedList(4096, true);
        if (roots.size() == 1 && (root = (OlapFile)roots.get(0)).isDirectory()) {
            String rootNodeId = root.getPath();
            String rootNodeCaption = root.getName();
            ArrayList<UxFileChooserTreeNode> children = new ArrayList<UxFileChooserTreeNode>();
            this.browseNodes(context, fs, rootNodeId, children);
            if (!children.isEmpty()) {
                nodes.add(new UxFileChooserTreeNode(rootNodeId, rootNodeCaption, UxFileChooserNodeType.Folder, children, false));
                return;
            }
        }
        for (OlapFile root2 : roots) {
            if (UxFileChooserNodeType.Folder == this.nodeType && !root2.isDirectory()) continue;
            String nodeName = root2.getName();
            String nodeId = root2.getPath();
            UxFileChooserNodeType type = root2.isDirectory() ? UxFileChooserNodeType.Folder : UxFileChooserNodeType.File;
            boolean hasLazyChildren = UxFileChooserQuery.hasLazyChildren(root2);
            nodes.add(new UxFileChooserTreeNode(nodeId, nodeName, type, !hasLazyChildren ? Collections.emptyList() : null, false));
        }
    }

    private void browseNodes(UxQueryContext context, OlapFileSystem fs, String nodeId, List<UxFileChooserTreeNode> nodes) throws IOException {
        List files = fs.sortedList(4096, nodeId, false);
        for (OlapFile file : files) {
            if (UxFileChooserNodeType.Folder == this.nodeType && !file.isDirectory()) continue;
            String fileName = file.getName();
            String fileId = file.getPath();
            UxFileChooserNodeType type = file.isDirectory() ? UxFileChooserNodeType.Folder : UxFileChooserNodeType.File;
            boolean hasLazyChildren = UxFileChooserQuery.hasLazyChildren(file);
            nodes.add(new UxFileChooserTreeNode(fileId, fileName, type, !hasLazyChildren ? Collections.emptyList() : null, false));
        }
    }

    private static boolean hasLazyChildren(OlapFile file) {
        boolean bl;
        block9: {
            if (!file.isDirectory()) {
                return false;
            }
            Path fileP = file.__getUnderlying().toPath();
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(fileP);
            try {
                bl = dirStream.iterator().hasNext();
                if (dirStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    OlapLoggers.UX_REQUEST.error((Object)"[UX] hasLazyChildren IO error", (Throwable)ex);
                    return false;
                }
            }
            dirStream.close();
        }
        return bl;
    }

    private UxReply executeForDashboards(UxQueryContext queryContext) {
        if (!"ic3-dashboards".equals(this.treeId)) {
            return UxReply.actionSuccess(new UxFileChooserTree(this.treeId, this.nodeId, null));
        }
        OlapEngineRequestContext requestContext = queryContext.getOlapEngineRequestContext();
        OlapBabylonService babylonService = requestContext.getBabylonService();
        IOlapDocsRequestContext repositoryContext = this.createRepositoryContext(queryContext);
        OlapDocsRepository repository = this.getDocsRepository(queryContext);
        OlapDocsGizmosRepository gizmos = repository.asGizmosRepository(OlapDocsGizmoEntityType.DASHBOARD);
        ArrayList<UxFileChooserTreeNode> nodes = new ArrayList<UxFileChooserTreeNode>();
        try {
            if (CdStringUtils.isNullOrBlank((String)this.nodeId)) {
                this.browseRootDashboards(babylonService, repositoryContext, gizmos, nodes);
            } else {
                this.browseDashboards(babylonService, repositoryContext, repository, gizmos, this.nodeId, nodes);
            }
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"file system browsing IO error", (Throwable)((Object)ex));
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"IO error", ex.getMessage()}));
        }
        return UxReply.actionSuccess(new UxFileChooserTree(this.treeId, this.nodeId, nodes));
    }

    private void browseRootDashboards(OlapBabylonService babylon, IOlapDocsRequestContext context, OlapDocsGizmosRepository gizmos, List<UxFileChooserTreeNode> nodes) throws OlapDocsErrorException {
        nodes.add(new UxFileChooserTreeNode("shared:", babylon.translate("docsShared", new Serializable[0]), UxFileChooserNodeType.Folder, null, false));
        nodes.add(new UxFileChooserTreeNode("/users/" + context.getUserName(), babylon.translate("docsMyDrive", new Serializable[0]), UxFileChooserNodeType.Folder, null, false));
        if (context.isDocAdministrator()) {
            nodes.add(new UxFileChooserTreeNode("users:", babylon.translate("docsUsers", new Serializable[0]), UxFileChooserNodeType.Folder, null, false));
        }
    }

    private void browseDashboards(OlapBabylonService babylon, IOlapDocsRequestContext context, OlapDocsRepository repository, OlapDocsGizmosRepository gizmos, @Nullable String nodeId, List<UxFileChooserTreeNode> nodes) throws OlapDocsErrorException {
        if (nodeId == null) {
            return;
        }
        OlapPath sPath = repository.fromLogicalSimplePath(context, nodeId);
        boolean isMyDrive = repository.isLogicalMyDriveSimplePath(context, nodeId);
        OlapDocsGizmoName namesR = gizmos.listGizmoNames(context, false, sPath, false);
        if (namesR.children != null) {
            for (OlapDocsGizmoName child : namesR.children) {
                nodes.add(new UxFileChooserTreeNode(repository.toLogicalSimplePath(context, isMyDrive, child.path), child.name, "RPF".equals(child.type) ? UxFileChooserNodeType.Folder : UxFileChooserNodeType.File, !"RPF".equals(child.type) ? Collections.emptyList() : null, false));
            }
        }
    }

    protected IOlapDocsRequestContext createRepositoryContext(UxQueryContext queryContext) {
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        return new OlapReportRepositoryRequestContext(serverRequestContext, CdVersion.create((String)"8.0.0"), null);
    }

    protected OlapDocsRepository getDocsRepository(UxQueryContext queryContext) {
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        return serverRequestContext.getApplicationContext().getDocsRepository(queryContext.asRuntimeContext());
    }
}

