/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts.mappings;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxLevelKeyPart;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxLevelKey
implements UxSerializable {
    private final boolean onError;
    private final UxLevelKeyPart[] parts;

    public UxLevelKey() {
        this(new UxLevelKeyPart[0]);
    }

    public UxLevelKey(UxLevelKeyPart part) {
        this(false, part);
    }

    public UxLevelKey(boolean onError, UxLevelKeyPart part) {
        this(onError, new UxLevelKeyPart[]{part});
    }

    public UxLevelKey(UxLevelKeyPart[] parts) {
        this(false, parts);
    }

    public UxLevelKey(boolean onError, UxLevelKeyPart[] parts) {
        this.onError = onError;
        this.parts = parts;
    }

    public boolean isOnError() {
        return this.onError;
    }

    public UxLevelKeyPart[] getParts() {
        return this.parts;
    }

    public static boolean isAllKeyTypesMatching(@Nullable List<UxLevelKey> keys) {
        if (keys == null || keys.isEmpty()) {
            return false;
        }
        UxLevelKey matchingKey = null;
        for (UxLevelKey key : keys) {
            if (key == null) {
                return false;
            }
            if (matchingKey == null) {
                matchingKey = key;
                continue;
            }
            if (matchingKey.equalsType(key)) continue;
            return false;
        }
        return true;
    }

    public UxLevelKey withNewName(String name) {
        UxLevelKeyPart[] newParts = new UxLevelKeyPart[this.parts.length];
        for (int ii = 0; ii < this.parts.length; ++ii) {
            UxLevelKeyPart part = this.parts[ii];
            newParts[ii] = new UxLevelKeyPart(name, part.getType(), part.getTypeConverter());
        }
        return new UxLevelKey(this.onError, newParts);
    }

    public int size() {
        return this.parts.length;
    }

    public boolean equalsType(UxLevelKey other) {
        if (this == other) {
            return true;
        }
        if (this.onError != other.onError) {
            return false;
        }
        return UxLevelKey.equalsType(this.parts, other.parts);
    }

    private static boolean equalsType(UxLevelKeyPart[] left, UxLevelKeyPart[] right) {
        if (left == null && right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        int length = left.length;
        if (right.length != length) {
            return false;
        }
        for (int ii = 0; ii < length; ++ii) {
            UxLevelKeyPart pLeft = left[ii];
            UxLevelKeyPart pRight = right[ii];
            if (pLeft == null && pRight == null) {
                return false;
            }
            if (pLeft == null || pRight == null) {
                return false;
            }
            if (pLeft.equalsType(pRight)) continue;
            return false;
        }
        return true;
    }
}

