/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts.mappings;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFactsMappings;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPathHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapParentChildHierarchyDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderTimeWizardHierarchy;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxTabularInfos;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsBridge;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsBridges;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMapping;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModel;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelAllLevels;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelIntermediateLevel;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelLastLevel;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelLevelList;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelNotMapped;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelNotSpecified;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelOnError;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingModelRangeFromTo;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingWizard;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappings;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxLevelKey;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxLevelKeyPart;
import crazydev.iccube.ux.common.field.UxEnumFieldType;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.type.UxEnumValue;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxFactsDimensionMappingBuilder {
    private final UxQueryContext context;
    private final UxBuilderSchemaLock lock;
    private final UxBuilderSchema schema;
    private final OlapBuilderFacts facts;
    private final List<IOlapBuilderDataColumnDef> factsColumns;
    private final List<UxLevelKeyPart> availableFactsColumns;
    private final Map<String, IOlapBuilderTabularDataDef> tables = new HashMap<String, IOlapBuilderTabularDataDef>();
    private final List<OlapBuilderLinkXmlDefinition> links;

    public UxFactsDimensionMappingBuilder(UxQueryContext context, UxBuilderSchemaLock lock, UxBuilderSchema schema, OlapBuilderFacts facts, @Nullable OlapBuilderFactsMappings mappings) {
        this.context = context;
        this.lock = lock;
        this.schema = schema;
        this.facts = facts;
        this.schema.forEachTabularData(lock, table -> this.tables.put(table.getId(), (IOlapBuilderTabularDataDef)table));
        this.links = mappings != null ? mappings.links : new ArrayList();
        String tableUUID = this.facts.getDataTableId();
        IOlapBuilderTabularDataDef factsTable = this.tables.get(tableUUID);
        this.factsColumns = factsTable != null ? factsTable.getSortedSelectedColumnsUX() : new ArrayList<IOlapBuilderDataColumnDef>();
        this.availableFactsColumns = UxFactsDimensionMappingBuilder.setupAvailableFactsColumns(context.getOlapBabylonService(), this.factsColumns);
    }

    public UxFactsDimensionMappings build() {
        UxTabularInfos tabularInfos = this.schema.getTabularInfos(this.lock, this.context.getOlapBabylonService(), this.facts.getDataTableId());
        ArrayList<UxFactsDimensionMapping> mappings = new ArrayList<UxFactsDimensionMapping>();
        this.schema.forEachDimension(this.lock, dimension -> {
            if (dimension.isFactIndexing()) {
                this.buildMapping((List<UxFactsDimensionMapping>)mappings, (IOlapBuilderDimensionDef)dimension);
            }
        });
        mappings.sort((o1, o2) -> {
            String type1 = o1.getTypeName();
            String type2 = o2.getTypeName();
            if (OlapBuilderDataViewLinksType.ON_ERROR.name().equals(type1)) {
                if (OlapBuilderDataViewLinksType.ON_ERROR.name().equals(type2)) {
                    return o1.getDimensionName().compareToIgnoreCase(o2.getDimensionName());
                }
                return -1;
            }
            if (OlapBuilderDataViewLinksType.ON_ERROR.name().equals(type2)) {
                return 1;
            }
            if (OlapBuilderDataViewLinksType.NOT_MAPPED.name().equals(type1)) {
                if (OlapBuilderDataViewLinksType.NOT_MAPPED.name().equals(type2)) {
                    return o1.getDimensionName().compareToIgnoreCase(o2.getDimensionName());
                }
                return 1;
            }
            if (OlapBuilderDataViewLinksType.NOT_MAPPED.name().equals(type2)) {
                return -1;
            }
            return o1.getDimensionName().compareToIgnoreCase(o2.getDimensionName());
        });
        UxBabylonService babylon = this.context.getUxBabylonService();
        String dimensionCaption = babylon.translate("dimMappingsDimension", new Serializable[0]);
        String fromLevelsCaption = babylon.translate("dimMappingsFromLevels", new Serializable[0]);
        String toFactsCaption = babylon.translate("dimMappingsToFacts", new Serializable[0]);
        String dimensionMissingHierarchy = babylon.translate("dimMappingsDimensionMissingHierarchy", new Serializable[0]);
        return new UxFactsDimensionMappings(dimensionCaption, fromLevelsCaption, toFactsCaption, dimensionMissingHierarchy, tabularInfos, mappings);
    }

    private void buildMapping(List<UxFactsDimensionMapping> mappings, IOlapBuilderDimensionDef dimension) {
        UxField type = this.setupType(dimension);
        IOlapBuilderDataViewLinksDef existingLink = this.getDefinedLink(dimension);
        UxEnumFieldType eTypes = (UxEnumFieldType)type.getMeta().getType();
        UxEnumValue[] eValues = eTypes.getValues();
        HashMap<String, UxFactsDimensionMappingModel> models = new HashMap<String, UxFactsDimensionMappingModel>();
        for (UxEnumValue eValue : eValues) {
            String value = eValue.getValue();
            if (OlapBuilderDataViewLinksType.ON_ERROR.name().equals(value)) {
                models.put(value, this.setupModelOnError(dimension));
                continue;
            }
            if (OlapBuilderDataViewLinksType.NOT_SPECIFIED.name().equals(value)) {
                models.put(value, this.setupModelNotSpecified());
                continue;
            }
            if (OlapBuilderDataViewLinksType.NOT_MAPPED.name().equals(value)) {
                models.put(value, this.setupModelNotMapped());
                continue;
            }
            if (OlapBuilderDataViewLinksType.LAST_LEVEL.name().equals(value)) {
                models.put(value, this.setupModelLastLevel(dimension, existingLink));
                continue;
            }
            if (OlapBuilderDataViewLinksType.ALL_LEVELS.name().equals(value)) {
                models.put(value, this.setupModelAllLevels(dimension, existingLink));
                continue;
            }
            if (OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL.name().equals(value)) {
                models.put(value, this.setupModelIntermediateLevel(dimension, existingLink));
                continue;
            }
            if (OlapBuilderDataViewLinksType.LEVEL_LIST.name().equals(value)) {
                models.put(value, this.setupModelLevelList(dimension, existingLink));
                continue;
            }
            if (OlapBuilderDataViewLinksType.RANGE_FROM_TO.name().equals(value)) {
                models.put(value, this.setupModelRangeFromTo(dimension, existingLink));
                continue;
            }
            throw new RuntimeException("internal error : type mismatch [" + value + "]");
        }
        UxFactsDimensionMappingWizard wizard = this.setupWizard(dimension, models);
        mappings.add(new UxFactsDimensionMapping(dimension.getId(), dimension.getName(), dimension.getDefaultHierarchy() != null, type, models, wizard));
    }

    private UxField setupType(IOlapBuilderDimensionDef dimension) {
        OlapBuilderDataViewLinksType type = this.type(dimension);
        HashSet<OlapBuilderDataViewLinksType> ignored = new HashSet<OlapBuilderDataViewLinksType>(Arrays.asList(OlapBuilderDataViewLinksType.OLD_GENERATION, OlapBuilderDataViewLinksType.MANY_TO_MANY));
        if (type == OlapBuilderDataViewLinksType.OLD_GENERATION) {
            type = OlapBuilderDataViewLinksType.ON_ERROR;
        } else if (type == OlapBuilderDataViewLinksType.MANY_TO_MANY) {
            type = OlapBuilderDataViewLinksType.ON_ERROR;
        } else {
            ignored.add(OlapBuilderDataViewLinksType.ON_ERROR);
        }
        Set<OlapBuilderDataViewLinksType> types = UxFactsDimensionMappingBuilder.types(dimension, this.lastLevelKeyPartCount(dimension), type);
        return new UxField("type", "type", null, new UxFieldMeta(UxFieldTypes.ENUM(this.context.getUxBabylonService(), OlapBuilderDataViewLinksType.class, types, ignored)), new UxFieldValue(type.name()));
    }

    private OlapBuilderDataViewLinksType type(IOlapBuilderDimensionDef dimension) {
        IOlapBuilderDataViewLinksDef definedLink = this.getDefinedLink(dimension);
        OlapBuilderDataViewLinksType type = definedLink != null ? definedLink.getType() : OlapBuilderDataViewLinksType.NOT_SPECIFIED;
        return type;
    }

    public static Set<OlapBuilderDataViewLinksType> types(IOlapBuilderDimensionDef dimension, int lastLevelKeyCount, OlapBuilderDataViewLinksType currentType) {
        HashSet<OlapBuilderDataViewLinksType> types = new HashSet<OlapBuilderDataViewLinksType>();
        types.add(OlapBuilderDataViewLinksType.NOT_SPECIFIED);
        types.add(OlapBuilderDataViewLinksType.NOT_MAPPED);
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        if (hierarchy == null) {
            return types;
        }
        types.add(OlapBuilderDataViewLinksType.LAST_LEVEL);
        if (!hierarchy.isParentChild()) {
            types.add(OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL);
        }
        if (dimension.isIndexingByRange() || hierarchy.isTimeWizard() || lastLevelKeyCount == 1) {
            types.add(OlapBuilderDataViewLinksType.RANGE_FROM_TO);
        }
        if (!dimension.isIndexingByRange()) {
            if (!hierarchy.isParentChild()) {
                types.add(OlapBuilderDataViewLinksType.LEVEL_LIST);
            }
            types.add(OlapBuilderDataViewLinksType.ALL_LEVELS);
        }
        boolean contained = false;
        for (OlapBuilderDataViewLinksType type : types) {
            if (!type.equals((Object)currentType)) continue;
            contained = true;
            break;
        }
        if (!contained) {
            types.add(currentType);
        }
        return types;
    }

    @Nullable
    private IOlapBuilderDataViewLinksDef getDefinedLink(IOlapBuilderDimensionDef dimension) {
        for (OlapBuilderLinkXmlDefinition link : this.links) {
            if (!dimension.getId().equals(link.getDimensionId())) continue;
            return link.getLink();
        }
        return null;
    }

    private int lastLevelKeyPartCount(IOlapBuilderDimensionDef dimension) {
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        if (hierarchy == null) {
            return -1;
        }
        if (hierarchy.isParentChild()) {
            return 1;
        }
        List<IOlapBuilderHierarchyLevelDef> levels = this.createHierarchyLevels(hierarchy);
        if (levels != null && !levels.isEmpty()) {
            int size;
            IOlapBuilderHierarchyLevelDef lastLevel = levels.get(levels.size() - 1);
            UxLevelKey levelKey = this.createLevelKey(dimension, hierarchy.isTimeWizard(), lastLevel);
            if (levelKey != null && (size = levelKey.size()) > 0) {
                return size;
            }
        }
        return -1;
    }

    private List<IOlapBuilderHierarchyLevelDef> createHierarchyLevels(@Nullable IOlapBuilderHierarchyDef hierarchy) {
        List hLevels;
        if (hierarchy == null) {
            return new ArrayList<IOlapBuilderHierarchyLevelDef>();
        }
        if (hierarchy instanceof OlapBuilderTimeWizardHierarchy) {
            OlapBuilderTimeWizardHierarchy tHierarchy = (OlapBuilderTimeWizardHierarchy)hierarchy;
            hLevels = tHierarchy.createLevels();
        } else {
            hLevels = hierarchy.getLevels();
        }
        return hLevels;
    }

    @Nullable
    private UxLevelKey createLevelKey(IOlapBuilderDimensionDef dimension, boolean isTimeWizard, @Nullable IOlapBuilderHierarchyLevelDef level) {
        if (isTimeWizard && level != null && level.getLevelType() != null) {
            OlapBabylonService babylon = this.context.getOlapBabylonService();
            OlapBuilderInputType date = level.getLevelType().hasTimeInformation() ? OlapBuilderInputType.DATETIME : OlapBuilderInputType.DATE;
            String type = babylon.translateEnum(OlapBuilderInputType.class, date.name());
            String[] typeConverter = new String[]{OlapBuilderInputType.DATE.getTypeConverter().getType().getName(), OlapBuilderInputType.DATETIME.getTypeConverter().getType().getName()};
            return new UxLevelKey(new UxLevelKeyPart(level.getName(), type, typeConverter));
        }
        IOlapBuilderTabularDataDef table = dimension.getDataView(this.tables);
        return this.createLevelKey(isTimeWizard, table, level);
    }

    @Nullable
    private UxLevelKey createLevelKey(boolean isTimeWizard, @Nullable IOlapBuilderTabularDataDef table, @Nullable IOlapBuilderHierarchyLevelDef level) {
        UxLevelKeyPart[] keyParts;
        if (level == null) {
            return null;
        }
        OlapBabylonService babylon = this.context.getOlapBabylonService();
        List keyColumns = level.getKeyColumnsRef();
        OlapBuilderDataColumnRef nameColumns = level.getNameColumnRef();
        if (keyColumns != null && !keyColumns.isEmpty()) {
            keyParts = new UxLevelKeyPart[keyColumns.size()];
            for (int ii = 0; ii < keyColumns.size(); ++ii) {
                OlapBuilderDataColumnRef keyColumn = (OlapBuilderDataColumnRef)keyColumns.get(ii);
                keyParts[ii] = UxLevelKeyPart.create(babylon, isTimeWizard, table, keyColumn);
            }
        } else {
            keyParts = nameColumns != null ? new UxLevelKeyPart[]{UxLevelKeyPart.create(babylon, isTimeWizard, table, nameColumns)} : null;
        }
        if (keyParts == null) {
            return null;
        }
        return new UxLevelKey(keyParts);
    }

    private boolean isAllKeyTypesMatching(boolean isTimeWizard, @Nullable IOlapBuilderTabularDataDef table, List<IOlapBuilderHierarchyLevelDef> levels) {
        if (table == null || levels == null || levels.isEmpty()) {
            return false;
        }
        ArrayList<UxLevelKey> levelKeys = new ArrayList<UxLevelKey>();
        for (IOlapBuilderHierarchyLevelDef level : levels) {
            UxLevelKey levelKey = this.createLevelKey(isTimeWizard, table, level);
            levelKeys.add(levelKey);
        }
        boolean matching = UxLevelKey.isAllKeyTypesMatching(levelKeys);
        return matching;
    }

    private Map<String, UxLevelKey> createLevelKeys(IOlapBuilderDimensionDef dimension, List<IOlapBuilderHierarchyLevelDef> availableLevels) {
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        HashMap<String, UxLevelKey> keys = new HashMap<String, UxLevelKey>();
        Iterator<IOlapBuilderHierarchyLevelDef> iterator = availableLevels.iterator();
        while (iterator.hasNext()) {
            IOlapBuilderHierarchyLevelDef availableLevel;
            UxLevelKey levelKeys = this.createLevelKey(dimension, hierarchy != null && hierarchy.isTimeWizard(), availableLevel = iterator.next());
            if (levelKeys == null) continue;
            keys.put(availableLevel.getName(), levelKeys);
        }
        return keys;
    }

    private static List<UxLevelKeyPart> setupAvailableFactsColumns(OlapBabylonService babylon, List<IOlapBuilderDataColumnDef> columns) {
        return columns.stream().map(col -> UxLevelKeyPart.create(babylon, false, col)).collect(Collectors.toList());
    }

    private List<String> setupSelectedBridgeColumns(List<OlapBuilderDataColumnRef> columnRefs) {
        return columnRefs.stream().map(OlapBuilderDataColumnRef::getName).collect(Collectors.toList());
    }

    private List<String> setupSelectedFactsColumns(@Nullable IOlapBuilderDataViewLinksDef existingLink) {
        if (existingLink == null) {
            return new ArrayList<String>();
        }
        List columnRefs = existingLink.getToColumnsRef();
        if (columnRefs == null) {
            return new ArrayList<String>();
        }
        return columnRefs.stream().map(OlapBuilderDataColumnRef::getName).collect(Collectors.toList());
    }

    private List<String> setupSelectedFactsColumnsFromTo(@Nullable IOlapBuilderDataViewLinksDef existingLink, int pos) {
        List columnRefs;
        ArrayList<String> cols = new ArrayList<String>();
        if (existingLink != null && (columnRefs = existingLink.getToColumnsRef()) != null && pos < columnRefs.size()) {
            cols.add(((OlapBuilderDataColumnRef)columnRefs.get(pos)).getName());
        }
        return cols;
    }

    private boolean isBridge(@Nullable IOlapBuilderDataViewLinksDef existingLink) {
        return existingLink != null && existingLink.isBridge();
    }

    @Nullable
    private UxFactsBridges setupBridge(@Nullable IOlapBuilderDataViewLinksDef existingLink) {
        if (existingLink == null || !existingLink.isBridge()) {
            return null;
        }
        ArrayList<UxFactsBridge> bridge = new ArrayList<UxFactsBridge>();
        List bridgeRefs = existingLink.getBridgesRef();
        for (OlapBuilderBridgeRef bridgeRef : bridgeRefs) {
            String uuid = bridgeRef.getBridgeTableId();
            List<String> joinFactsColumns = this.setupSelectedBridgeColumns(bridgeRef.getFactJoin());
            List<String> joinBridgeColumns = this.setupSelectedBridgeColumns(bridgeRef.getBridgeJoin());
            List<String> keyBridgeColumns = this.setupSelectedBridgeColumns(bridgeRef.getBridgeKey());
            boolean one2one = bridgeRef.isOneToOne();
            bridge.add(new UxFactsBridge(uuid, joinFactsColumns, joinBridgeColumns, keyBridgeColumns, one2one));
        }
        return new UxFactsBridges(bridge);
    }

    private UxFactsDimensionMappingModel setupModelOnError(IOlapBuilderDimensionDef dimension) {
        OlapBuilderDataViewLinksType type = this.type(dimension);
        UxBabylonService babylon = this.context.getUxBabylonService();
        String error = type == OlapBuilderDataViewLinksType.OLD_GENERATION ? babylon.translate("dimMapping_error_old_generation", new Serializable[0]) : (type == OlapBuilderDataViewLinksType.MANY_TO_MANY ? babylon.translate("dimMapping_error_many_to_many", new Serializable[0]) : babylon.translate("dimMapping_error_dunno", new Serializable[]{type.name()}));
        return new UxFactsDimensionMappingModelOnError(error);
    }

    private UxFactsDimensionMappingModel setupModelNotSpecified() {
        return new UxFactsDimensionMappingModelNotSpecified();
    }

    private UxFactsDimensionMappingModel setupModelNotMapped() {
        return new UxFactsDimensionMappingModelNotMapped();
    }

    private UxFactsDimensionMappingModel setupModelLastLevel(IOlapBuilderDimensionDef dimension, @Nullable IOlapBuilderDataViewLinksDef existingLink) {
        UxLevelKey levelKey;
        String levelName;
        UxBabylonService babylon = this.context.getUxBabylonService();
        IOlapBuilderTabularDataDef table = dimension.getDataView(this.tables);
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        if (hierarchy instanceof IOlapParentChildHierarchyDef) {
            IOlapParentChildHierarchyDef pcHierarchy = (IOlapParentChildHierarchyDef)hierarchy;
            key = pcHierarchy.getMemberKeyColumnRef();
            if (key != null) {
                levelName = babylon.translate("dimMapping_lastLevel", new Serializable[0]);
                levelKey = new UxLevelKey(UxLevelKeyPart.create(this.context.getOlapBabylonService(), false, table, key));
            } else {
                levelName = babylon.translate("dimMapping_lastLevel", new Serializable[0]);
                levelKey = new UxLevelKey();
            }
        } else if (hierarchy instanceof IOlapBuilderPathHierarchyDef) {
            IOlapBuilderPathHierarchyDef pHierarchy = (IOlapBuilderPathHierarchyDef)hierarchy;
            key = pHierarchy.getPathColumnRef();
            if (key != null) {
                levelName = babylon.translate("dimMapping_lastLevel", new Serializable[0]);
                levelKey = new UxLevelKey(UxLevelKeyPart.create(this.context.getOlapBabylonService(), false, table, key));
            } else {
                levelName = babylon.translate("dimMapping_lastLevel", new Serializable[0]);
                levelKey = new UxLevelKey();
            }
        } else {
            List<IOlapBuilderHierarchyLevelDef> levels = this.createHierarchyLevels(hierarchy);
            if (levels != null && !levels.isEmpty()) {
                IOlapBuilderHierarchyLevelDef lastLevel = levels.get(levels.size() - 1);
                levelName = lastLevel.getName();
                levelKey = this.createLevelKey(dimension, hierarchy != null && hierarchy.isTimeWizard(), lastLevel);
            } else {
                levelName = babylon.translate("dimMapping_notAvailable", new Serializable[0]);
                levelKey = new UxLevelKey();
            }
        }
        List<String> selectedFactsColumns = this.setupSelectedFactsColumns(existingLink);
        UxFactsBridges bridge = this.setupBridge(existingLink);
        return new UxFactsDimensionMappingModelLastLevel(levelName, levelKey, this.isBridge(existingLink), selectedFactsColumns, bridge);
    }

    private UxFactsDimensionMappingModel setupModelAllLevels(IOlapBuilderDimensionDef dimension, @Nullable IOlapBuilderDataViewLinksDef existingLink) {
        UxLevelKey levelKey;
        String levelName;
        UxBabylonService babylon = this.context.getUxBabylonService();
        IOlapBuilderTabularDataDef table = dimension.getDataView(this.tables);
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        if (hierarchy instanceof IOlapParentChildHierarchyDef) {
            IOlapParentChildHierarchyDef pcHierarchy = (IOlapParentChildHierarchyDef)hierarchy;
            OlapBuilderDataColumnRef key = pcHierarchy.getMemberKeyColumnRef();
            if (key != null) {
                levelName = babylon.translate("dimMapping_anyLevel", new Serializable[0]);
                levelKey = new UxLevelKey(UxLevelKeyPart.create(this.context.getOlapBabylonService(), false, table, key));
            } else {
                levelName = babylon.translate("dimMapping_anyLevel", new Serializable[0]);
                levelKey = new UxLevelKey();
            }
        } else if (hierarchy instanceof IOlapBuilderPathHierarchyDef) {
            IOlapBuilderPathHierarchyDef pHierarchy = (IOlapBuilderPathHierarchyDef)hierarchy;
            OlapBuilderDataColumnRef key = pHierarchy.getPathColumnRef();
            if (key != null) {
                levelName = babylon.translate("dimMapping_anyLevel", new Serializable[0]);
                levelKey = new UxLevelKey(UxLevelKeyPart.create(this.context.getOlapBabylonService(), false, table, key));
            } else {
                levelName = babylon.translate("dimMapping_anyLevel", new Serializable[0]);
                levelKey = new UxLevelKey();
            }
        } else {
            List<IOlapBuilderHierarchyLevelDef> levels = this.createHierarchyLevels(hierarchy);
            if (levels != null && !levels.isEmpty()) {
                boolean isTimeWizard;
                boolean bl = isTimeWizard = hierarchy != null && hierarchy.isTimeWizard();
                if (this.isAllKeyTypesMatching(isTimeWizard, table, levels)) {
                    IOlapBuilderHierarchyLevelDef anyLevel = levels.get(0);
                    UxLevelKey anyKey = this.createLevelKey(dimension, isTimeWizard, anyLevel);
                    levelName = babylon.translate("dimMapping_anyLevel", new Serializable[0]);
                    levelKey = anyKey.withNewName("*");
                } else {
                    levelName = babylon.translate("dimMapping_anyLevel", new Serializable[0]);
                    levelKey = new UxLevelKey(true, new UxLevelKeyPart("*", babylon.translate("dimMapping_keyTypesMismatch", new Serializable[0]), null));
                }
            } else {
                levelName = babylon.translate("dimMapping_dunno", new Serializable[0]);
                levelKey = new UxLevelKey();
            }
        }
        List<String> selectedFactsColumns = this.setupSelectedFactsColumns(existingLink);
        UxFactsBridges bridge = this.setupBridge(existingLink);
        return new UxFactsDimensionMappingModelAllLevels(levelName, levelKey, this.isBridge(existingLink), selectedFactsColumns, bridge);
    }

    private UxFactsDimensionMappingModel setupModelIntermediateLevel(IOlapBuilderDimensionDef dimension, @Nullable IOlapBuilderDataViewLinksDef existingLink) {
        List names;
        String selectedLevelName;
        UxBabylonService babylon = this.context.getUxBabylonService();
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        List<IOlapBuilderHierarchyLevelDef> availableLevels = this.createHierarchyLevels(hierarchy);
        List<String> availableLevelNames = availableLevels.stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.toList());
        Map<String, UxLevelKey> levelKeys = this.createLevelKeys(dimension, availableLevels);
        String string = selectedLevelName = availableLevelNames.size() > 0 ? (String)availableLevelNames.get(0) : null;
        if (existingLink != null && existingLink.getType() == OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL && (names = existingLink.getFromLevelNames()) != null && names.size() > 0) {
            selectedLevelName = (String)names.get(0);
        }
        UxField levels = new UxField("level", "level", null, new UxFieldMeta(UxFieldTypes.ENUMERABLE(babylon, IOlapBuilderHierarchyLevelDef.class, availableLevelNames)), new UxFieldValue(selectedLevelName));
        List<String> selectedFactsColumns = this.setupSelectedFactsColumns(existingLink);
        UxFactsBridges bridge = this.setupBridge(existingLink);
        return new UxFactsDimensionMappingModelIntermediateLevel(levels, levelKeys, this.isBridge(existingLink), selectedFactsColumns, bridge);
    }

    private UxFactsDimensionMappingModel setupModelLevelList(IOlapBuilderDimensionDef dimension, @Nullable IOlapBuilderDataViewLinksDef existingLink) {
        List names;
        UxBabylonService babylon = this.context.getUxBabylonService();
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        List<IOlapBuilderHierarchyLevelDef> availableLevels = this.createHierarchyLevels(hierarchy);
        List<String> availableLevelNames = availableLevels.stream().map(IOlapBuilderNamedDef::getName).collect(Collectors.toList());
        Map<String, UxLevelKey> levelKeys = this.createLevelKeys(dimension, availableLevels);
        ArrayList<String> selectedLevelNames = new ArrayList<String>();
        if (availableLevelNames.size() > 0) {
            selectedLevelNames.add((String)availableLevelNames.get(0));
        }
        if (existingLink != null && existingLink.getType() == OlapBuilderDataViewLinksType.LEVEL_LIST && (names = existingLink.getFromLevelNames()) != null && names.size() > 0) {
            selectedLevelNames.clear();
            selectedLevelNames.addAll(names);
        }
        UxField levels = new UxField("levels", "levels", null, new UxFieldMeta(UxFieldTypes.ENUMERABLES(babylon, IOlapBuilderHierarchyLevelDef.class, availableLevelNames)), new UxFieldValue(selectedLevelNames));
        List<String> selectedFactsColumns = this.setupSelectedFactsColumns(existingLink);
        UxFactsBridges bridge = this.setupBridge(existingLink);
        return new UxFactsDimensionMappingModelLevelList(levels, levelKeys, this.isBridge(existingLink), selectedFactsColumns, bridge, babylon.translate("dimMapping_keyTypesMismatch", new Serializable[0]));
    }

    private UxFactsDimensionMappingModel setupModelRangeFromTo(IOlapBuilderDimensionDef dimension, @Nullable IOlapBuilderDataViewLinksDef existingLink) {
        UxLevelKey levelKey;
        String levelName;
        UxBabylonService babylon = this.context.getUxBabylonService();
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        List<IOlapBuilderHierarchyLevelDef> levels = this.createHierarchyLevels(hierarchy);
        if (levels != null && !levels.isEmpty()) {
            IOlapBuilderHierarchyLevelDef lastLevel = levels.get(levels.size() - 1);
            levelName = lastLevel.getName();
            levelKey = this.createLevelKey(dimension, hierarchy != null && hierarchy.isTimeWizard(), lastLevel);
        } else {
            levelName = babylon.translate("dimMapping_notAvailable", new Serializable[0]);
            levelKey = new UxLevelKey();
        }
        List<String> selectedFactsColumnsFrom = this.setupSelectedFactsColumnsFromTo(existingLink, 0);
        List<String> selectedFactsColumnsTo = this.setupSelectedFactsColumnsFromTo(existingLink, 1);
        return new UxFactsDimensionMappingModelRangeFromTo(levelName, levelKey, selectedFactsColumnsFrom, selectedFactsColumnsTo);
    }

    @Nullable
    private UxFactsDimensionMappingWizard setupWizard(IOlapBuilderDimensionDef dimension, Map<String, UxFactsDimensionMappingModel> models) {
        IOlapBuilderHierarchyDef hierarchy = dimension.getDefaultHierarchy();
        if (hierarchy == null) {
            return null;
        }
        if (hierarchy.isParentChild()) {
            UxFactsDimensionMappingModel model = models.get(OlapBuilderDataViewLinksType.ALL_LEVELS.name());
            return this.setupWizardAllLevels(dimension.getName(), (UxFactsDimensionMappingModelAllLevels)model);
        }
        UxFactsDimensionMappingModel model = models.get(OlapBuilderDataViewLinksType.LAST_LEVEL.name());
        return this.setupWizardLastLevel(dimension.getName(), (UxFactsDimensionMappingModelLastLevel)model);
    }

    @Nullable
    private UxFactsDimensionMappingWizard setupWizardLastLevel(String dimension, UxFactsDimensionMappingModelLastLevel model) {
        UxLevelKey levelKey = model.getLevelKey();
        List<String> selectedFactsColumns = this.setupWizardSelectedColumns(dimension, levelKey, this.availableFactsColumns);
        if (selectedFactsColumns == null || selectedFactsColumns.isEmpty()) {
            return null;
        }
        return new UxFactsDimensionMappingWizard(model.getType(), selectedFactsColumns);
    }

    @Nullable
    private UxFactsDimensionMappingWizard setupWizardAllLevels(String dimension, UxFactsDimensionMappingModelAllLevels model) {
        UxLevelKey levelKey = model.getLevelKey();
        if (levelKey.isOnError()) {
            return null;
        }
        List<String> selectedFactsColumns = this.setupWizardSelectedColumns(dimension, levelKey, this.availableFactsColumns);
        if (selectedFactsColumns == null || selectedFactsColumns.isEmpty()) {
            return null;
        }
        return new UxFactsDimensionMappingWizard(model.getType(), selectedFactsColumns);
    }

    @Nullable
    private List<String> setupWizardSelectedColumns(String dimension, UxLevelKey levelKey, List<UxLevelKeyPart> availableFactsColumns) {
        if (availableFactsColumns == null || availableFactsColumns.isEmpty()) {
            return null;
        }
        UxLevelKeyPart[] parts = levelKey.getParts();
        if (parts == null || parts.length == 0) {
            return null;
        }
        ArrayList<String> selectedFactsColumns = new ArrayList<String>();
        for (UxLevelKeyPart part : parts) {
            String column = this.setupWizardSelectedColumn(availableFactsColumns, dimension, part.getName(), part.getType(), part.getTypeConverter());
            if (column == null) {
                return null;
            }
            selectedFactsColumns.add(column);
        }
        return selectedFactsColumns;
    }

    @Nullable
    private String setupWizardSelectedColumn(List<UxLevelKeyPart> availableFactsColumns, String dimension, String name, @Nullable String type, @Nullable String[] typeConverter) {
        List<UxLevelKeyPart> typedColumns = this.filterFactsColumnsByType(availableFactsColumns, type, typeConverter);
        if (typedColumns == null || typedColumns.isEmpty()) {
            return null;
        }
        if (CdStringUtils.isNullOrBlank((String)name)) {
            if (typedColumns.size() == 1) {
                return typedColumns.get(0).getName();
            }
            return null;
        }
        return this.filterFactsColumnsByName(typedColumns, dimension, name);
    }

    @Nullable
    private List<UxLevelKeyPart> filterFactsColumnsByType(List<UxLevelKeyPart> availableFactsColumns, @Nullable String type, @Nullable String[] typeConverter) {
        if (type == null || typeConverter == null) {
            return availableFactsColumns;
        }
        ArrayList<UxLevelKeyPart> filtered = new ArrayList<UxLevelKeyPart>();
        UxLevelKeyPart keyPart = new UxLevelKeyPart("ignored-level-name", type, typeConverter);
        for (UxLevelKeyPart availableFactsColumn : availableFactsColumns) {
            String cType = availableFactsColumn.getType();
            if (cType == null) {
                filtered.add(availableFactsColumn);
                continue;
            }
            String[] cTypeConverter = availableFactsColumn.getTypeConverter();
            if (cTypeConverter == null) {
                filtered.add(availableFactsColumn);
                continue;
            }
            if (!keyPart.equalsType(availableFactsColumn)) continue;
            filtered.add(availableFactsColumn);
        }
        return filtered;
    }

    @Nullable
    private String filterFactsColumnsByName(List<UxLevelKeyPart> availableFactsColumns, String dimensionName, String keyName) {
        if (availableFactsColumns.size() == 1) {
            return availableFactsColumns.get(0).getName();
        }
        String column = null;
        double columnSimilarity = Double.NEGATIVE_INFINITY;
        for (UxLevelKeyPart availableFactColumn : availableFactsColumns) {
            String columnName = availableFactColumn.getName();
            if ("id".equalsIgnoreCase(columnName) || "_id".equalsIgnoreCase(columnName)) continue;
            double similarity = CdStringUtils.similarity((String)keyName, (String)columnName);
            if (similarity > columnSimilarity) {
                columnSimilarity = similarity;
                column = availableFactColumn.getName();
            }
            if ((similarity = CdStringUtils.similarity((String)(dimensionName + keyName), (String)columnName)) > columnSimilarity) {
                columnSimilarity = similarity;
                column = availableFactColumn.getName();
            }
            if (columnSimilarity != 1.0) continue;
            return availableFactColumn.getName();
        }
        return column;
    }
}

