/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts.create;

import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.ux.meta.facts.wizard.UxBuilderCreateMeasureGroupWizard;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveMeasureGroupWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;

    public UxSaveMeasureGroupWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        int revNumber = -1;
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            Object operation;
            UxBuilderCreateMeasureGroupWizard wizard = UxWizardDef.setupCreateMeasureGroupWizardFromJson(queryContext, this.props, -1, this.stepDefs, this.stepModels);
            OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(true);
            IOlapBuilderBaseFactsDef measureGroupUI = wizard.getCreatedMeasureGroupFromUI();
            UxBuilderMeasureGroupReference measureGroupRef = null;
            if (measureGroupUI != null) {
                measureGroupRef = schema.insertMeasureGroup(lock, measureGroupUI);
                operation = "add measure group: " + UxBuilderMeasureGroupUniqueName.create(measureGroupRef.cube, measureGroupRef.measureGroup).asString();
            } else {
                errorManager.addError((CdErrorCode)OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"missing wizard view"});
                operation = "n/a";
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, (String)operation);
            UxActionContinuation continuation = measureGroupRef != null ? new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxMeasureGroupQueryMeta.createUseCase(queryContext, UxActionSetup.ALL, this.schemaId, null, UxBuilderMeasureGroupUniqueName.create(measureGroupRef.cube, measureGroupRef.measureGroup))) : new UxActionContinuation(UxActionContinuationKind.NAVIGATE, queryContext.getUseCase(UxBuilderUseCaseName.Measures, this.schemaId));
            return UxReply.actionSuccess(continuation);
        });
    }
}

