/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxMeasureGroupsQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxMeasureGroupsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableHeaders header = UxTableHeaders.create(babylon, "measureGroupNameEx", "description", "cubeNameEx");
            UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<UxBuilderMeasureGroupReference>("cubeNameEx", babylon.translate("filterCubeName", new Serializable[0]), UxBuilderMeasureGroupReference::getCubeName), new UxFilterMeta<UxBuilderMeasureGroupReference>("measureGroupNameEx", babylon.translate("filterFactsName", new Serializable[0]), UxBuilderMeasureGroupReference::getMeasureGroupName));
            UxTableRowSearcher<UxBuilderMeasureGroupReference> searcher = new UxTableRowSearcher<UxBuilderMeasureGroupReference>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean isAccepting(UxBuilderMeasureGroupReference row, String searchText) {
                    return this.isContaining(searchText, row.getCubeName(), row.getMeasureGroupName());
                }
            };
            ArrayList facts_ = new ArrayList();
            schema.forEachMeasureGroups(lock, facts_::add);
            facts_.sort((o1, o2) -> {
                int cmp = o1.getCubeName().compareToIgnoreCase(o2.getCubeName());
                if (cmp == 0) {
                    return o1.getMeasureGroupName().compareToIgnoreCase(o2.getMeasureGroupName());
                }
                return cmp;
            });
            List facts = this.filter(this.tableOptions, searcher, filterMetas, facts_);
            int totalRowCount = facts.size();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (UxBuilderMeasureGroupReference fact : facts) {
                rows.add(UxMeasureGroupsQuery.createRow(queryContext, this.schemaId, fact));
            }
            UxTable table = UxTable.create(options, header, rows);
            UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
            return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
        });
    }

    private static UxTableRow createRow(UxQueryContext context, UxSchemaId schemaId, UxBuilderMeasureGroupReference facts) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxMeasureGroupQueryMeta.createUseCase(context, schemaId, null, UxBuilderMeasureGroupUniqueName.create(facts.cube, facts.measureGroup));
        cells.add(new UxTableCell((Object)facts.getMeasureGroupName(), useCase));
        cells.add(new UxTableCell(facts.getMeasureGroupDescription()));
        cells.add(new UxTableCell(facts.getCubeName()));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.MeasureGroups, this.schemaId));
    }
}

