/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxSaveMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxMeasureGroupQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderMeasureGroupUniqueName measureGroupName;
    private UxBuilderMeasureGroupReference measureGroup;

    public UxMeasureGroupQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderMeasureGroupUniqueName measureGroupName) {
        super(meta, requestId, schemaId);
        this.measureGroupName = measureGroupName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.measureGroup = schema.getExistingMeasureGroup(lock, this.measureGroupName);
            if (!this.measureGroup.measureGroup.isNewGeneration()) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_FACTS_OLD_GENERATION, (Serializable[])new Serializable[]{this.measureGroupName.asString()}));
            }
            UxMeasureGroupQuery.solveViewsForFactsMappings(lock, schema);
            this.measureGroup.fixCubeName();
            this.setModelTypesSetupInfoForMeasureGroup(queryContext, lock, schema, true, false, false);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, schema, this.measureGroup.measureGroup, true);
            UxAction save = UxSaveMeasureGroupQueryMeta.createAction(queryContext, this.schemaId, this.measureGroupName);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.measureGroup != null) {
            reply.withUseCase(UxMeasureGroupQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderMeasureGroupUniqueName.create(this.measureGroup.cube, this.measureGroup.measureGroup)));
        }
    }
}

