/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.facts;

import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderUniqueNameError;
import crazydev.iccube.ux.builder.queries.facts.UxFactsLinksOverviewQuery;
import crazydev.iccube.ux.builder.queries.facts.UxFactsLinksOverviewQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxFactsLinksOverviewReplyPayload;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class UxDownloadLinksOverviewQuery
extends UxSchemaBuilderQuery {
    public UxDownloadLinksOverviewQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        try {
            return this.executeQueryForPersistentSchemaUnsafe(queryContext);
        }
        catch (UxBuilderUniqueNameError error) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)"[ux.builder] unexpected error", (Throwable)error);
            UxBabylonService babylon = queryContext.getUxBabylonService();
            String param = babylon.translateActionCaption(UxFactsLinksOverviewQueryMeta.FactsLinksOverview.queryName().name(), new Serializable[0]);
            String information = babylon.translate("builder.linksOverviewSetupError", new Serializable[]{param});
            return UxReply.error(information);
        }
    }

    private UxReply executeQueryForPersistentSchemaUnsafe(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxFactsLinksOverviewReplyPayload overview = UxFactsLinksOverviewQuery.createLinksOverview(queryContext, lock, this.schemaId, schema);
            byte[] content = this.generateXls(queryContext, overview);
            String filename = schema.getName() + "-links.xls";
            String mimeType = "application/vnd.ms-excel";
            UxFileWrapper wrapper = UxFileWrapper.forBinary(filename, content, "application/vnd.ms-excel");
            return new UxAttachmentReply(wrapper, null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateXls(UxQueryContext context, UxFactsLinksOverviewReplyPayload overview) {
        byte[] byArray;
        List<String> dimensions = overview.dimensionNames;
        List<String> measureGroups = overview.measureGroupNames;
        UxFactsLinksOverviewReplyPayload.Type[][] types = overview.types;
        ByteArrayOutputStream out = null;
        try {
            HSSFWorkbook wb = this.generateXlsWorkBook(context, dimensions, measureGroups, types);
            out = new ByteArrayOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            byArray = out.toByteArray();
        }
        catch (Exception ex) {
            byte[] byArray2;
            try {
                OlapLoggers.BUILDER.error((Object)"[links] could not generate the XLS file", (Throwable)ex);
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            return byArray2;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return byArray;
    }

    private HSSFWorkbook generateXlsWorkBook(UxQueryContext context, List<String> dimensions, List<String> measureGroups, UxFactsLinksOverviewReplyPayload.Type[][] types) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        int rowIdx = 0;
        HSSFRow header = sheet.createRow(rowIdx++);
        HSSFCell cell = header.createCell(0);
        cell.setCellValue("Dimensions");
        for (int mm = 0; mm < measureGroups.size(); ++mm) {
            HSSFCell cell2 = header.createCell(1 + mm);
            cell2.setCellValue(measureGroups.get(mm));
        }
        for (int dd = 0; dd < dimensions.size(); ++dd) {
            HSSFRow row = sheet.createRow(rowIdx++);
            HSSFCell cell3 = row.createCell(0);
            cell3.setCellValue(dimensions.get(dd));
            for (int mm = 0; mm < measureGroups.size(); ++mm) {
                HSSFCell cell4 = row.createCell(1 + mm);
                UxFactsLinksOverviewReplyPayload.Type type = types[dd][mm];
                if (type == null) {
                    cell4.setCellValue("");
                    continue;
                }
                if (OlapBuilderDataViewLinksType.NOT_MAPPED.name().equals(type.id)) {
                    cell4.setCellValue("");
                    continue;
                }
                cell4.setCellValue(type.caption);
            }
        }
        return wb;
    }
}

