/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.collection.CdCollections;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.ux.meta.common.model.UxSchemaInfoReadI;
import crazydev.iccube.builder.ux.meta.dimension.wizard.UxBuilderCreateDimensionWizard;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.model.UxSchemaInfoR;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.wizarddef.UxWizardDef;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxSaveDimensionWizardQuery
extends UxSchemaBuilderQuery {
    private final Object props;
    private final Object stepDefs;
    private final Object stepModels;

    public UxSaveDimensionWizardQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable Object props, Object stepDefs, Object stepModels) {
        super(meta, requestId, schemaId);
        this.props = props;
        this.stepDefs = stepDefs;
        this.stepModels = stepModels;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        int revNumber = -1;
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            UxSchemaInfoR info = schema.getSchemaInfoR(lock, queryContext);
            UxBuilderCreateDimensionWizard wizard = UxWizardDef.setupCreateDimensionWizardFromJson(queryContext, lock, schema, this.props, -1, this.stepDefs, this.stepModels);
            List persistentList = wizard.getModelFromUi((UxSchemaInfoReadI)info, (CdBabylonService)queryContext.getUxBabylonService());
            if (persistentList.isEmpty()) {
                return UxReply.actionSuccess(new UxActionStatus(queryContext.getUxBabylonService().translate("NoDimensionToAdd", new Serializable[0])));
            }
            List<IOlapBuilderDimensionDef> dimensions = persistentList.stream().filter(p -> p instanceof IOlapBuilderDimensionDef).map(p -> (IOlapBuilderDimensionDef)p).collect(Collectors.toList());
            schema.insertDimensions(lock, dimensions);
            List<OlapBuilderFacts> facts = persistentList.stream().filter(p -> p instanceof OlapBuilderFacts).map(p -> (OlapBuilderFacts)p).collect(Collectors.toList());
            schema.insertMeasureGroups(lock, facts);
            this.setupDimFactsLinks(lock, schema, wizard, dimensions);
            String operation = this.getLogMessage(dimensions, facts);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            if (dimensions.size() == 1) {
                IOlapBuilderDimensionDef dimension0 = dimensions.get(0);
                UxUseCase continuation = UxDimensionQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderDimensionUniqueName.create(dimension0), dimension0.withCreateHierarchy());
                return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, continuation));
            }
            if (dimensions.size() > 1) {
                return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, queryContext.getUseCase(UxBuilderUseCaseName.SemanticLayer, this.schemaId)));
            }
            if (facts.size() > 1) {
                return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, queryContext.getUseCase(UxBuilderUseCaseName.Measures, this.schemaId)));
            }
            return UxReply.actionSuccess(new UxActionStatus(queryContext.getUxBabylonService().translate("NoDimensionToAdd", new Serializable[0])));
        });
    }

    private void setupDimFactsLinks(UxBuilderSchemaLock lock, UxBuilderSchema schema, UxBuilderCreateDimensionWizard wizard, List<IOlapBuilderDimensionDef> dimensions) {
        try {
            UxBuilderCreateDimensionWizard.WizardCreatedDimStatusEnum createMode = wizard.getCreatedDimStatus();
            if (createMode == UxBuilderCreateDimensionWizard.WizardCreatedDimStatusEnum.CREATED_AS_NOT_MAPPED_LINK) {
                for (IOlapBuilderDimensionDef dimension : dimensions) {
                    this.setupDimFactsLinks_NOT_MAPPED(lock, schema, dimension);
                }
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)"[dimension] could not set the dimension/facts links", (Throwable)ex);
        }
    }

    private void setupDimFactsLinks_NOT_MAPPED(UxBuilderSchemaLock lock, UxBuilderSchema schema, IOlapBuilderDimensionDef dimension) {
        schema.forEachMeasureGroups(lock, reference -> {
            if (reference.measureGroup instanceof OlapBuilderFacts) {
                OlapBuilderFacts facts = (OlapBuilderFacts)reference.measureGroup;
                facts.addLink(dimension, (IOlapBuilderDataViewLinksDef)new OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType.NOT_MAPPED));
            }
        });
    }

    private String getLogMessage(List<IOlapBuilderDimensionDef> dimensions, List<OlapBuilderFacts> facts) {
        Object message = "";
        if (dimensions.size() == 1) {
            message = "add dimension: " + dimensions.get(0).getName();
        } else if (!dimensions.isEmpty()) {
            message = "add dimensions : " + CdCollections.toString(dimensions, (String)"");
        }
        if (facts.size() == 1) {
            message = (((String)message).equals("") ? "" : ", ") + "add facts: " + facts.get(0).getName();
        } else if (!facts.isEmpty()) {
            message = (((String)message).equals("") ? "" : ", ") + "add facts : " + CdCollections.toString(facts, (String)"");
        }
        if (((String)message).equals("")) {
            message = "n/a";
        }
        return message;
    }
}

