/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveDimensionQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderDimensionUniqueName dimensionName;
    private final UxModel model;

    public UxSaveDimensionQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderDimensionUniqueName dimensionName, UxModel model) {
        super(meta, requestId, schemaId);
        this.dimensionName = dimensionName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)converter.convertToServerModel(queryContext, this.model);
            if (!dimension.getUUID().equals(this.dimensionName.asUUID())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_UUID_MISMATCH, (Serializable[])new Serializable[]{this.dimensionName.asUUID(), dimension.getUUID()}));
            }
            if (!this.dimensionName.getDimensionName().equals(dimension.getName())) {
                IOlapBuilderDimensionDef existingDimension = schema.renameDimension(lock, this.dimensionName, dimension.getName());
                converter.update(existingDimension, dimension);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxDimensionQueryMeta.createUseCase(queryContext, this.schemaId, null, UxBuilderDimensionUniqueName.create(existingDimension), existingDimension.withCreateHierarchy()));
                operation = "rename/edit dimension: " + this.dimensionName.asString() + " into: " + dimension.getName();
            } else {
                IOlapBuilderDimensionDef existingDimension = schema.getExistingDimension(lock, this.dimensionName);
                converter.update(existingDimension, dimension);
                continuation = null;
                operation = "edit dimension: " + this.dimensionName.asString();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

