/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxResultDockType;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.queries.datatable.browse.UxTablePage;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableBrowseReply;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableRow;
import java.util.ArrayList;

public class UxPreviewDynamicHierarchiesQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderDimensionUniqueName dimensionName;

    public UxPreviewDynamicHierarchiesQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderDimensionUniqueName dimensionName) {
        super(meta, requestId, schemaId);
        this.dimensionName = dimensionName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            IOlapBuilderDimensionDef dimension = schema.getExistingDimension(lock, this.dimensionName);
            UxResultDockName dockName = new UxResultDockName(UxResultDockType.DIMENSION_DYNAMIC_HIERARCHIES, dimension.getName(), dimension.getName());
            UxTableHeaders headers = new UxTableHeaders(new UxTableHeader("name1", "caption1"), new UxTableHeader("name2", "caption2"));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
            cells.add(new UxTableCell("value1"));
            cells.add(new UxTableCell("value2"));
            rows.add(new UxTableRow(cells));
            UxTable table = UxTable.create(headers, rows);
            UxTablePage page = new UxTablePage(100, 1, table);
            return UxReply.actionSuccess((UxActionResult)new UxTableBrowseReply(null, page), dockName);
        });
    }
}

