/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.dimension;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxExtraNavigationKeyId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNodeId;
import crazydev.iccube.ux.builder.queries.dimension.UxCreateDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDeleteDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQuery;
import crazydev.iccube.ux.builder.queries.dimension.UxDuplicateDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxCreateHierarchyQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDimensionQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxDimensionQueryMeta Dimension = new UxDimensionQueryMeta();

    protected UxDimensionQueryMeta() {
        super(UxConsoleConstants.QueryName.Dimension);
    }

    @Override
    @Nullable
    public UxUrl helpUrl() {
        return UxUrlConstants.HELP_SCHEMA_SEMANTIC_LAYER;
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderDimensionUniqueName name = params.getExistingDimensionNameParameter("name");
        return new UxDimensionQuery(this, params.getRequestId(), schemaId, name);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, UxBuilderDimensionUniqueName name) {
        return this.createQueryUrl(schemaId).addParam("name", name.asUrlParam());
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, @Nullable UxBuilderDimensionUniqueName prevName, UxBuilderDimensionUniqueName name, boolean withCreateHierarchy) {
        return UxDimensionQueryMeta.createUseCase(context, UxActionSetup.ALL, schemaId, prevName, name, withCreateHierarchy);
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxActionSetup actionSetup, UxSchemaId schemaId, @Nullable UxBuilderDimensionUniqueName prevName, UxBuilderDimensionUniqueName name, boolean withCreateHierarchy) {
        List<UxAction> actions = null;
        if (actionSetup == UxActionSetup.ALL) {
            actions = Dimension.createActions(context, schemaId);
            actions.add(UxCreateDimensionQueryMeta.createAction(context, schemaId, 2));
            if (withCreateHierarchy) {
                actions.add(UxCreateHierarchyQueryMeta.createAction(context, schemaId, name, 8));
            }
            actions.add(UxDimensionBrowseQueryMeta.createAction(context, schemaId, name));
            actions.add(UxDuplicateDimensionQueryMeta.createAction(context, schemaId, name));
            actions.add(UxDeleteDimensionQueryMeta.createAction(context, schemaId, name));
        } else if (actionSetup == UxActionSetup.NAVIGATION_TREE) {
            actions = new ArrayList<UxAction>();
            actions.add(UxCreateHierarchyQueryMeta.createAction(context, schemaId, name, 2));
            actions.add(UxCreateDimensionQueryMeta.createAction(context, schemaId, 2));
            actions.add(UxDimensionBrowseQueryMeta.createAction(context, schemaId, name));
            actions.add(UxDuplicateDimensionQueryMeta.createAction(context, schemaId, name));
            actions.add(UxDeleteDimensionQueryMeta.createAction(context, schemaId, name));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = Dimension.createQueryUrl(schemaId, name);
        UxUseCaseBuilder builder = new UxUseCaseBuilder(context, Dimension, schemaId).withId(UxBuilderUseCaseName.Dimension, name.getDimensionName()).withExtraNavigationKeyId(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(name))).withCaption(babylon.translate("dimensionUC", new Serializable[]{name.getDimensionName()})).withParentId(UxBuilderUseCaseName.SemanticLayer).withUrl(url).withActions(actions);
        if (prevName != null) {
            builder = builder.withExtraNavigationKeyId_(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(prevName)));
        }
        return builder.build(actionSetup != UxActionSetup.NONE);
    }
}

